/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.entity.item.Parameter;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.TestItemResults;
import com.epam.ta.reportportal.ws.converter.builders.TestCaseIdEntry;
import com.epam.ta.reportportal.ws.converter.converters.ItemAttributeConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class TestItemBuilder
implements Supplier<TestItem> {
    public static final String PARAMETER_NULL_VALUE = "NULL";
    private TestItem testItem;

    public TestItemBuilder() {
        this.testItem = new TestItem();
    }

    public TestItemBuilder(TestItem testItem) {
        this.testItem = testItem;
    }

    public TestItemBuilder addStartItemRequest(StartTestItemRQ rq) {
        this.testItem.setStartTime((LocalDateTime)EntityUtils.TO_LOCAL_DATE_TIME.apply(rq.getStartTime()));
        this.testItem.setName(rq.getName().trim());
        this.testItem.setUniqueId(rq.getUniqueId());
        this.testItem.setUuid(Optional.ofNullable(rq.getUuid()).orElse(UUID.randomUUID().toString()));
        this.testItem.setHasStats(rq.isHasStats());
        TestCaseIdEntry testCaseIdEntry = this.processTestCaseId(rq.getTestCaseId(), rq.getCodeRef(), rq.getParameters());
        this.testItem.setTestCaseId(testCaseIdEntry.getId());
        this.testItem.setTestCaseHash(Integer.valueOf(testCaseIdEntry.getHash()));
        this.testItem.setCodeRef(rq.getCodeRef());
        TestItemResults testItemResults = new TestItemResults();
        testItemResults.setStatus(StatusEnum.IN_PROGRESS);
        testItemResults.setTestItem(this.testItem);
        this.testItem.setItemResults(testItemResults);
        this.addDescription(rq.getDescription());
        this.addParameters(rq.getParameters());
        this.addType(rq.getType());
        return this;
    }

    public TestItemBuilder addLaunchId(Long launchId) {
        this.testItem.setLaunchId(launchId);
        return this;
    }

    public TestItemBuilder addParent(TestItem parent) {
        this.testItem.setParent(parent);
        return this;
    }

    public TestItemBuilder addType(String typeValue) {
        Optional type = TestItemTypeEnum.fromValue((String)typeValue);
        BusinessRule.expect((Object)type, Optional::isPresent).verify(ErrorType.UNSUPPORTED_TEST_ITEM_TYPE, new Object[]{typeValue});
        this.testItem.setType((TestItemTypeEnum)type.get());
        return this;
    }

    public TestItemBuilder addDescription(String description) {
        Optional.ofNullable(description).ifPresent(it -> this.testItem.setDescription(it.trim()));
        return this;
    }

    public TestItemBuilder addStatus(StatusEnum statusEnum) {
        this.testItem.getItemResults().setStatus(statusEnum);
        return this;
    }

    public TestItemBuilder addAttributes(Set<ItemAttributesRQ> attributes) {
        Optional.ofNullable(attributes).ifPresent(it -> this.testItem.getAttributes().addAll(it.stream().map(val -> {
            ItemAttribute itemAttribute = ItemAttributeConverter.FROM_RESOURCE.apply((ItemAttributeResource)val);
            itemAttribute.setTestItem(this.testItem);
            return itemAttribute;
        }).collect(Collectors.toSet())));
        return this;
    }

    public TestItemBuilder overwriteAttributes(Set<ItemAttributeResource> attributes) {
        if (attributes != null) {
            Set overwrittenAttributes = this.testItem.getAttributes().stream().filter(ItemAttribute::isSystem).collect(Collectors.toSet());
            attributes.stream().map(val -> {
                ItemAttribute itemAttribute = ItemAttributeConverter.FROM_RESOURCE.apply((ItemAttributeResource)val);
                itemAttribute.setTestItem(this.testItem);
                return itemAttribute;
            }).forEach(overwrittenAttributes::add);
            this.testItem.setAttributes(overwrittenAttributes);
        }
        return this;
    }

    public TestItemBuilder addTestItemResults(TestItemResults testItemResults) {
        Preconditions.checkNotNull((Object)testItemResults, (Object)"Provided value shouldn't be null");
        this.testItem.setItemResults(testItemResults);
        this.addDuration(testItemResults.getEndTime());
        return this;
    }

    public TestItemBuilder addDuration(LocalDateTime endTime) {
        Preconditions.checkNotNull((Object)endTime, (Object)"Provided value shouldn't be null");
        Preconditions.checkNotNull((Object)this.testItem.getItemResults(), (Object)"Test item results shouldn't be null");
        this.testItem.getItemResults().setDuration(Double.valueOf((double)ChronoUnit.MILLIS.between(this.testItem.getStartTime(), endTime) / 1000.0));
        return this;
    }

    public TestItemBuilder addParameters(List<ParameterResource> parameters) {
        if (!CollectionUtils.isEmpty(parameters)) {
            this.testItem.setParameters(parameters.stream().map(it -> {
                Parameter parameter = new Parameter();
                parameter.setKey(it.getKey());
                parameter.setValue(Optional.ofNullable(it.getValue()).orElse(PARAMETER_NULL_VALUE));
                return parameter;
            }).collect(Collectors.toSet()));
        }
        return this;
    }

    private TestCaseIdEntry processTestCaseId(String testCaseId, String codeRef, List<ParameterResource> params) {
        if (Objects.nonNull(testCaseId)) {
            return new TestCaseIdEntry(testCaseId, testCaseId.hashCode());
        }
        if (Objects.nonNull(codeRef)) {
            String id = TestItemBuilder.compose(codeRef, params);
            return new TestCaseIdEntry(id, id.hashCode());
        }
        return TestCaseIdEntry.empty();
    }

    private static String compose(String codeRef, List<ParameterResource> parameters) {
        return CollectionUtils.isEmpty(parameters) ? codeRef : codeRef + "[" + parameters.stream().map(ParameterResource::getValue).collect(Collectors.joining(",")) + "]";
    }

    @Override
    public TestItem get() {
        return this.testItem;
    }
}

