/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.entity.enums.SendCase;
import com.epam.ta.reportportal.entity.project.email.LaunchAttributeRule;
import com.epam.ta.reportportal.entity.project.email.SenderCase;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.epam.ta.reportportal.ws.model.project.email.SenderCaseDTO;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class NotificationConfigConverter {
    public static final Function<Set<SenderCase>, List<SenderCaseDTO>> TO_RESOURCE = senderCaseSet -> senderCaseSet.stream().map(TO_CASE_RESOURCE).collect(Collectors.toList());
    public static final Function<LaunchAttributeRule, ItemAttributeResource> TO_ATTRIBUTE_RULE_RESOURCE = model -> {
        ItemAttributeResource attributeResource = new ItemAttributeResource();
        attributeResource.setKey(model.getKey());
        attributeResource.setValue(model.getValue());
        return attributeResource;
    };
    public static final Function<SenderCase, SenderCaseDTO> TO_CASE_RESOURCE = model -> {
        Preconditions.checkNotNull((Object)model);
        SenderCaseDTO resource = new SenderCaseDTO();
        resource.setLaunchNames((List)Lists.newArrayList((Iterable)model.getLaunchNames()));
        Optional.ofNullable(model.getLaunchAttributeRules()).ifPresent(launchAttributeRules -> resource.setAttributes(launchAttributeRules.stream().map(TO_ATTRIBUTE_RULE_RESOURCE).collect(Collectors.toSet())));
        resource.setSendCase(model.getSendCase().getCaseString());
        resource.setRecipients((List)Lists.newArrayList((Iterable)model.getRecipients()));
        resource.setEnabled(model.isEnabled());
        return resource;
    };
    public static final Function<ItemAttributeResource, LaunchAttributeRule> TO_ATTRIBUTE_RULE_MODEL = resource -> {
        LaunchAttributeRule launchAttributeRule = new LaunchAttributeRule();
        launchAttributeRule.setKey(resource.getKey());
        launchAttributeRule.setValue(resource.getValue());
        return launchAttributeRule;
    };
    public static final Function<SenderCaseDTO, SenderCase> TO_CASE_MODEL = resource -> {
        SenderCase senderCase = new SenderCase();
        Optional.ofNullable(resource.getAttributes()).ifPresent(attributes -> senderCase.setLaunchAttributeRules(attributes.stream().map(attribute -> {
            LaunchAttributeRule launchAttributeRule = TO_ATTRIBUTE_RULE_MODEL.apply((ItemAttributeResource)attribute);
            launchAttributeRule.setSenderCase(senderCase);
            return launchAttributeRule;
        }).collect(Collectors.toSet())));
        Optional.ofNullable(resource.getLaunchNames()).ifPresent(launchNames -> senderCase.setLaunchNames((Set)Sets.newHashSet((Iterable)launchNames)));
        senderCase.setRecipients((Set)Sets.newHashSet((Iterable)resource.getRecipients()));
        senderCase.setSendCase((SendCase)SendCase.findByName((String)resource.getSendCase()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Incorrect send case type " + resource.getSendCase()})));
        senderCase.setEnabled(resource.isEnabled());
        return senderCase;
    };

    private NotificationConfigConverter() {
    }
}

