/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.pattern.selector.condition;

import com.epam.ta.reportportal.commons.querygen.CompositeFilterCondition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsMode;
import com.epam.ta.reportportal.core.analyzer.pattern.selector.condition.PatternConditionProvider;
import com.epam.ta.reportportal.core.analyzer.pattern.selector.condition.impl.AutoAnalyzedPatternConditionProvider;
import com.epam.ta.reportportal.core.analyzer.pattern.selector.condition.impl.ManualPatternConditionProvider;
import com.epam.ta.reportportal.core.analyzer.pattern.selector.condition.impl.ToInvestigatePatternConditionProvider;
import com.epam.ta.reportportal.dao.IssueGroupRepository;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PatternConditionProviderChain {
    private final Set<PatternConditionProvider> patternConditionProviders = Sets.newHashSet((Object[])new PatternConditionProvider[]{new AutoAnalyzedPatternConditionProvider(AnalyzeItemsMode.AUTO_ANALYZED), new ManualPatternConditionProvider(AnalyzeItemsMode.MANUALLY_ANALYZED), new ToInvestigatePatternConditionProvider(AnalyzeItemsMode.TO_INVESTIGATE, () -> issueGroupRepository.findByTestItemIssueGroup(TestItemIssueGroup.TO_INVESTIGATE))});

    @Autowired
    public PatternConditionProviderChain(IssueGroupRepository issueGroupRepository) {
    }

    public Optional<ConvertibleCondition> provideCondition(Set<AnalyzeItemsMode> analyzeItemsModes) {
        List convertibleConditions = this.patternConditionProviders.stream().map(provider -> provider.provideCondition(analyzeItemsModes)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return convertibleConditions.isEmpty() ? Optional.empty() : Optional.of(new CompositeFilterCondition(convertibleConditions, Operator.AND));
    }
}

