/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.strategy;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.strategy.LaunchAnalysisStrategy;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.function.Predicate;

public abstract class AbstractLaunchAnalysisStrategy
implements LaunchAnalysisStrategy {
    protected final ProjectRepository projectRepository;
    protected final LaunchRepository launchRepository;

    protected AbstractLaunchAnalysisStrategy(ProjectRepository projectRepository, LaunchRepository launchRepository) {
        this.projectRepository = projectRepository;
        this.launchRepository = launchRepository;
    }

    protected void validateLaunch(Launch launch, ReportPortalUser.ProjectDetails projectDetails) {
        BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Launch with ID '{}' is not under '{}' project.", (Object[])new Object[]{launch.getId(), projectDetails.getProjectName()})});
        BusinessRule.expect((Object)launch.getMode(), (Predicate)Predicates.equalTo((Object)LaunchModeEnum.DEFAULT)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Cannot analyze launches in debug mode."});
    }
}

