/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler;

import com.epam.ta.reportportal.core.integration.migration.JiraEmailSecretMigrationService;
import com.epam.ta.reportportal.core.integration.migration.LdapSecretMigrationService;
import com.epam.ta.reportportal.core.integration.migration.RallySecretMigrationService;
import com.epam.ta.reportportal.core.integration.migration.SaucelabsSecretMigrationService;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.filesystem.DataStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class IntegrationSecretsMigrationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationSecretsMigrationHandler.class);
    @Value(value="${rp.integration.salt.path:keystore}")
    private String integrationSaltPath;
    @Value(value="${rp.integration.salt.migration:migration}")
    private String migrationFile;
    private final DataStore dataStore;
    private final JiraEmailSecretMigrationService jiraEmailSecretMigrationService;
    private final RallySecretMigrationService rallySecretMigrationService;
    private final SaucelabsSecretMigrationService saucelabsSecretMigrationService;
    private final LdapSecretMigrationService ldapSecretMigrationService;

    @Autowired
    public IntegrationSecretsMigrationHandler(DataStore dataStore, JiraEmailSecretMigrationService jiraEmailSecretMigrationService, RallySecretMigrationService rallySecretMigrationService, SaucelabsSecretMigrationService saucelabsSecretMigrationService, LdapSecretMigrationService ldapSecretMigrationService) {
        this.dataStore = dataStore;
        this.jiraEmailSecretMigrationService = jiraEmailSecretMigrationService;
        this.rallySecretMigrationService = rallySecretMigrationService;
        this.saucelabsSecretMigrationService = saucelabsSecretMigrationService;
        this.ldapSecretMigrationService = ldapSecretMigrationService;
    }

    @EventListener
    public void migrate(ApplicationReadyEvent event) throws IOException {
        String migrationFilePath = this.integrationSaltPath + File.separator + this.migrationFile;
        try (InputStream load = this.dataStore.load(migrationFilePath);){
            ExecutorService executor = Executors.newFixedThreadPool(4);
            executor.execute(this.jiraEmailSecretMigrationService::migrate);
            executor.execute(this.rallySecretMigrationService::migrate);
            executor.execute(this.saucelabsSecretMigrationService::migrate);
            executor.execute(this.ldapSecretMigrationService::migrate);
            executor.shutdown();
            this.dataStore.delete(migrationFilePath);
        }
        catch (ReportPortalException ex) {
            LOGGER.info("Secrets migration is not needed");
        }
    }
}

