/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.utils;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.dao.constant.WidgetContentRepositoryConstants;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.filter.ObjectType;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class DefaultLaunchFilterProvider {
    public static Pair<Queryable, Pageable> createDefaultLaunchQueryablePair(ReportPortalUser.ProjectDetails projectDetails, UserFilter userFilter, int launchesLimit) {
        Filter launchFilter = DefaultLaunchFilterProvider.createLaunchFilter(projectDetails, userFilter);
        Pageable launchPageable = DefaultLaunchFilterProvider.createLaunchPageable(userFilter, launchesLimit);
        return Pair.of((Object)launchFilter, (Object)launchPageable);
    }

    private static Filter createLaunchFilter(ReportPortalUser.ProjectDetails projectDetails, UserFilter launchFilter) {
        DefaultLaunchFilterProvider.validateLaunchFilterTarget(launchFilter);
        Filter filter = Filter.builder().withTarget(launchFilter.getTargetClass().getClassObject()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("projectId", String.valueOf(projectDetails.getProjectId())).build()).withCondition((ConvertibleCondition)FilterCondition.builder().withCondition(Condition.NOT_EQUALS).withSearchCriteria("status").withValue(StatusEnum.IN_PROGRESS.name()).build()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("mode", Mode.DEFAULT.toString()).build()).build();
        filter.getFilterConditions().addAll(launchFilter.getFilterCondition());
        return filter;
    }

    private static void validateLaunchFilterTarget(UserFilter launchFilter) {
        BusinessRule.expect((Object)launchFilter, f -> ObjectType.Launch.equals((Object)f.getTargetClass())).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Incorrect filter target - '{}'. Allowed: '{}'", (Object[])new Object[]{launchFilter.getTargetClass(), ObjectType.Launch})});
    }

    private static Pageable createLaunchPageable(UserFilter launchFilter, int launchesLimit) {
        BusinessRule.expect((Object)launchesLimit, limit -> limit > 0 && limit <= WidgetContentRepositoryConstants.LAUNCHES_COUNT).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launches limit should be greater than 0 and less or equal to 600"});
        Sort sort = Optional.ofNullable(launchFilter.getFilterSorts()).map(sorts -> Sort.by(sorts.stream().map(s -> Sort.Order.by((String)s.getField()).with(s.getDirection())).collect(Collectors.toList()))).orElseGet(Sort::unsorted);
        return PageRequest.of((int)0, (int)launchesLimit, (Sort)sort);
    }
}

