/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log.impl;

import com.epam.ta.reportportal.binary.AttachmentBinaryDataService;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.item.TestItemService;
import com.epam.ta.reportportal.core.log.DeleteLogHandler;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DeleteLogHandlerImpl
implements DeleteLogHandler {
    private final LogRepository logRepository;
    private final AttachmentBinaryDataService attachmentBinaryDataService;
    private final ProjectRepository projectRepository;
    private final TestItemService testItemService;
    private final LogIndexer logIndexer;

    public DeleteLogHandlerImpl(LogRepository logRepository, AttachmentBinaryDataService attachmentBinaryDataService, ProjectRepository projectRepository, TestItemService testItemService, LogIndexer logIndexer) {
        this.logRepository = logRepository;
        this.attachmentBinaryDataService = attachmentBinaryDataService;
        this.projectRepository = projectRepository;
        this.testItemService = testItemService;
        this.logIndexer = logIndexer;
    }

    @Override
    public OperationCompletionRS deleteLog(Long logId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()}));
        Log log = this.validate(logId, user, projectDetails);
        try {
            this.logRepository.delete((Object)log);
            this.cleanUpLogData(log);
        }
        catch (Exception exc) {
            throw new ReportPortalException("Error while Log instance deleting.", (Throwable)exc);
        }
        this.logIndexer.cleanIndex(projectDetails.getProjectId(), Collections.singletonList(logId));
        return new OperationCompletionRS(Suppliers.formattedSupplier((String)"Log with ID = '{}' successfully deleted.", (Object[])new Object[]{logId}).toString());
    }

    private void cleanUpLogData(Log log) {
        Optional.ofNullable(log.getAttachment()).ifPresent(a -> {
            if (StringUtils.isNotBlank((CharSequence)a.getFileId())) {
                this.attachmentBinaryDataService.delete(a.getFileId());
            }
            if (StringUtils.isNotBlank((CharSequence)a.getThumbnailId())) {
                this.attachmentBinaryDataService.delete(a.getThumbnailId());
            }
        });
    }

    private Log validate(Long logId, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        Log log = (Log)this.logRepository.findById((Object)logId).orElseThrow(() -> new ReportPortalException(ErrorType.LOG_NOT_FOUND, new Object[]{logId}));
        Optional<TestItem> itemOptional = Optional.ofNullable(log.getTestItem());
        Launch launch = Optional.ofNullable(log.getTestItem()).map(this.testItemService::getEffectiveLaunch).orElseGet(() -> ((Log)log).getLaunch());
        if (itemOptional.isPresent()) {
            BusinessRule.expect((Object)itemOptional.get().getItemResults().getStatistics(), (Predicate)Predicates.notNull()).verify(ErrorType.TEST_ITEM_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete log '{}' when test item '{}' in progress state", (Object[])new Object[]{log.getId(), itemOptional.get().getItemId()})});
        } else {
            BusinessRule.expect((Object)launch.getStatus(), (Predicate)Predicates.not((Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.IN_PROGRESS}))).verify(ErrorType.LAUNCH_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete log '{}' when launch '{}' in progress state", (Object[])new Object[]{log.getId(), launch.getId()})});
        }
        BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Log '{}' not under specified '{}' project", (Object[])new Object[]{logId, projectDetails.getProjectId()})});
        if (user.getUserRole() != UserRole.ADMINISTRATOR && !Objects.equals(user.getUserId(), launch.getUserId())) {
            BusinessRule.expect((Object)projectDetails.getProjectRole(), (Predicate)Predicates.equalTo((Object)ProjectRole.PROJECT_MANAGER)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        return log;
    }
}

