/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.impl;

import com.epam.ta.reportportal.auth.acl.ShareableObjectsHandler;
import com.epam.ta.reportportal.binary.UserBinaryDataService;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.project.DeleteProjectHandler;
import com.epam.ta.reportportal.core.user.DeleteUserHandler;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.enums.ProjectType;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.DeleteBulkRQ;
import com.epam.ta.reportportal.ws.model.DeleteBulkRS;
import com.epam.ta.reportportal.ws.model.ErrorRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteUserHandlerImpl
implements DeleteUserHandler {
    private final UserBinaryDataService dataStore;
    private final UserRepository userRepository;
    private final DeleteProjectHandler deleteProjectHandler;
    private final ShareableObjectsHandler shareableObjectsHandler;

    @Autowired
    public DeleteUserHandlerImpl(UserRepository userRepository, DeleteProjectHandler deleteProjectHandler, ShareableObjectsHandler shareableObjectsHandler, UserBinaryDataService dataStore) {
        this.userRepository = userRepository;
        this.deleteProjectHandler = deleteProjectHandler;
        this.shareableObjectsHandler = shareableObjectsHandler;
        this.dataStore = dataStore;
    }

    @Override
    public OperationCompletionRS deleteUser(Long userId, ReportPortalUser loggedInUser) {
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{userId}));
        BusinessRule.expect((Object)Objects.equals(userId, loggedInUser.getUserId()), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"You cannot delete own account"});
        ArrayList projectIdsToDelete = Lists.newArrayList();
        user.getProjects().forEach(userProject -> {
            Long projectId = userProject.getId().getProjectId();
            if (ProjectUtils.isPersonalForUser((ProjectType)userProject.getProject().getProjectType(), (String)userProject.getProject().getName(), (String)user.getLogin())) {
                projectIdsToDelete.add(projectId);
            } else {
                this.shareableObjectsHandler.preventSharedObjects(projectId, user.getLogin());
                ProjectUtils.excludeProjectRecipients((Iterable)Lists.newArrayList((Object[])new User[]{user}), (Project)userProject.getProject());
            }
        });
        this.dataStore.deleteUserPhoto(user);
        this.userRepository.delete((Object)user);
        if (CollectionUtils.isNotEmpty((Collection)projectIdsToDelete)) {
            this.deleteProjectHandler.deleteProjects(new DeleteBulkRQ((List)projectIdsToDelete));
        }
        return new OperationCompletionRS("User with ID = '" + userId + "' successfully deleted.");
    }

    @Override
    public DeleteBulkRS deleteUsers(DeleteBulkRQ deleteBulkRQ, ReportPortalUser currentUser) {
        ArrayList exceptions = Lists.newArrayList();
        ArrayList deleted = Lists.newArrayList();
        deleteBulkRQ.getIds().forEach(userId -> {
            try {
                this.deleteUser((Long)userId, currentUser);
                deleted.add(userId);
            }
            catch (ReportPortalException rp) {
                exceptions.add(rp);
            }
        });
        return new DeleteBulkRS((List)deleted, Collections.emptyList(), exceptions.stream().map(ex -> {
            ErrorRS errorResponse = new ErrorRS();
            errorResponse.setErrorType(ex.getErrorType());
            errorResponse.setMessage(ex.getMessage());
            return errorResponse;
        }).collect(Collectors.toList()));
    }
}

