/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.binary.UserBinaryDataService;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.events.attachment.DeleteProjectAttachmentsEvent;
import com.epam.ta.reportportal.dao.IssueTypeRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectIssueType;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.util.PersonalProjectService;
import com.epam.ta.reportportal.ws.converter.builders.UserBuilder;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQFull;
import io.minio.MinioClient;
import java.util.Set;
import java.util.stream.Collectors;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public class FlushingDataJob
implements Job {
    private final Logger LOGGER = LoggerFactory.getLogger((String)this.getClass().getName());
    private static final String SUPERADMIN_PERSONAL = "superadmin_personal";
    private static final String SUPERADMIN = "superadmin";
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private PersonalProjectService personalProjectService;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private LogIndexer logIndexer;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private UserBinaryDataService dataStore;
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private PasswordEncoder passwordEncoder;

    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public void execute(JobExecutionContext context) {
        this.LOGGER.info("Flushing demo instance data is starting...");
        this.truncateTables();
        this.projectRepository.findAllProjectNames().stream().filter(it -> !it.equalsIgnoreCase(SUPERADMIN_PERSONAL)).collect(Collectors.toList()).forEach(name -> this.projectRepository.findByName(name).ifPresent(this::deleteProject));
        this.userRepository.findAll().stream().filter(it -> !it.getLogin().equalsIgnoreCase(SUPERADMIN)).forEach(this::deleteUser);
        this.restartSequences();
        this.createDefaultUser();
        this.LOGGER.info("Flushing demo instance data finished");
    }

    private void truncateTables() {
        this.jdbcTemplate.execute("BEGIN; SELECT pg_advisory_xact_lock(1);SELECT pg_terminate_backend(pid) FROM pg_stat_activity WHERE datname = 'reportportal'\nAND pid <> pg_backend_pid()\nAND state IN ('idle', 'idle in transaction', 'idle in transaction (aborted)', 'disabled'); TRUNCATE TABLE launch RESTART IDENTITY CASCADE;TRUNCATE TABLE activity RESTART IDENTITY CASCADE;TRUNCATE TABLE shareable_entity RESTART IDENTITY CASCADE;TRUNCATE TABLE ticket RESTART IDENTITY CASCADE;TRUNCATE TABLE issue_ticket RESTART IDENTITY CASCADE;COMMIT;");
    }

    private void restartSequences() {
        this.jdbcTemplate.execute("ALTER SEQUENCE project_id_seq RESTART WITH 2");
        this.jdbcTemplate.execute("ALTER SEQUENCE users_id_seq RESTART WITH 2");
        this.jdbcTemplate.execute("ALTER SEQUENCE oauth_access_token_id_seq RESTART WITH 2");
        this.jdbcTemplate.execute("ALTER SEQUENCE project_attribute_attribute_id_seq RESTART WITH 15");
        this.jdbcTemplate.execute("ALTER SEQUENCE statistics_field_sf_id_seq RESTART WITH 15");
    }

    private void createDefaultUser() {
        CreateUserRQFull request = new CreateUserRQFull();
        request.setLogin("default");
        request.setPassword(this.passwordEncoder.encode((CharSequence)"1q2w3e"));
        request.setEmail("defaultemail@domain.com");
        User user = new UserBuilder().addCreateUserFullRQ(request).addUserRole(UserRole.USER).get();
        this.projectRepository.save((Object)this.personalProjectService.generatePersonalProject(user));
        this.userRepository.save((Object)user);
        this.LOGGER.info("Default user has been successfully created.");
    }

    private void deleteUser(User user) {
        this.dataStore.deleteUserPhoto(user);
        this.userRepository.delete((Object)user);
        this.userRepository.flush();
        this.LOGGER.info("User with id = '" + user.getId() + "' has been successfully deleted.");
    }

    private void deleteProject(Project project) {
        Set defaultIssueTypeIds = this.issueTypeRepository.getDefaultIssueTypes().stream().map(IssueType::getId).collect(Collectors.toSet());
        Set issueTypesToRemove = project.getProjectIssueTypes().stream().map(ProjectIssueType::getIssueType).filter(issueType -> !defaultIssueTypeIds.contains(issueType.getId())).collect(Collectors.toSet());
        this.projectRepository.delete((Object)project);
        this.issueTypeRepository.deleteAll(issueTypesToRemove);
        try {
            this.minioClient.deleteBucketLifeCycle("prj-" + project.getId());
        }
        catch (Exception e) {
            this.LOGGER.warn("Cannot delete attachments bucket prj-" + project.getId());
        }
        this.logIndexer.deleteIndex(project.getId());
        this.projectRepository.flush();
        this.eventPublisher.publishEvent((Object)new DeleteProjectAttachmentsEvent(project.getId()));
        this.LOGGER.info("Project with id = '" + project.getId() + "' has been successfully deleted.");
    }
}

