/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util.email;

import com.epam.reportportal.commons.template.TemplateEngine;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.EmailSettingsEnum;
import com.epam.ta.reportportal.entity.enums.IntegrationGroupEnum;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.email.EmailService;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MailServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailServiceFactory.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final String FROM_ADDRESS = "fromAddress";
    private final TemplateEngine templateEngine;
    private final BasicTextEncryptor encryptor;
    private final IntegrationRepository integrationRepository;
    private final IntegrationTypeRepository integrationTypeRepository;

    @Autowired
    public MailServiceFactory(TemplateEngine templateEngine, BasicTextEncryptor encryptor, IntegrationRepository integrationRepository, IntegrationTypeRepository integrationTypeRepository) {
        this.templateEngine = templateEngine;
        this.encryptor = encryptor;
        this.integrationRepository = integrationRepository;
        this.integrationTypeRepository = integrationTypeRepository;
    }

    public Optional<EmailService> getEmailService(Integration integration) {
        BusinessRule.expect((Object)integration, (Predicate)Predicates.notNull()).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Integration should be not null."});
        if (!integration.isEnabled()) {
            return Optional.empty();
        }
        Map config = integration.getParams().getParams();
        if (MapUtils.isNotEmpty((Map)config)) {
            boolean authRequired = Optional.ofNullable(config.get(EmailSettingsEnum.AUTH_ENABLED.getAttribute())).map(e -> BooleanUtils.toBoolean((String)String.valueOf(e))).orElse(false);
            Properties javaMailProperties = new Properties();
            javaMailProperties.put("mail.smtp.connectiontimeout", (Object)5000);
            javaMailProperties.put("mail.smtp.auth", (Object)authRequired);
            javaMailProperties.put("mail.smtp.starttls.enable", (Object)(authRequired && Optional.ofNullable(config.get(EmailSettingsEnum.STAR_TLS_ENABLED.getAttribute())).map(e -> BooleanUtils.toBoolean((String)String.valueOf(e))).orElse(false) != false ? 1 : 0));
            if (Optional.ofNullable(config.get(EmailSettingsEnum.SSL_ENABLED.getAttribute())).map(e -> BooleanUtils.toBoolean((String)String.valueOf(e))).orElse(false).booleanValue()) {
                javaMailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                javaMailProperties.put("mail.smtp.socketFactory.fallback", "false");
            }
            EmailService service = new EmailService(javaMailProperties);
            service.setTemplateEngine(this.templateEngine);
            EmailSettingsEnum.HOST.getAttribute(config).ifPresent(arg_0 -> ((EmailService)service).setHost(arg_0));
            service.setPort(Optional.ofNullable(config.get(EmailSettingsEnum.PORT.getAttribute())).map(p -> NumberUtils.toInt((String)String.valueOf(p), (int)25)).orElse(25));
            EmailSettingsEnum.PROTOCOL.getAttribute(config).ifPresent(arg_0 -> ((EmailService)service).setProtocol(arg_0));
            EmailSettingsEnum.FROM.getAttribute(config).ifPresent(service::setFrom);
            if (authRequired) {
                EmailSettingsEnum.USERNAME.getAttribute(config).ifPresent(arg_0 -> ((EmailService)service).setUsername(arg_0));
                EmailSettingsEnum.PASSWORD.getAttribute(config).ifPresent(password -> service.setPassword(this.encryptor.decrypt(password)));
            }
            return Optional.of(service);
        }
        return Optional.empty();
    }

    public Optional<EmailService> getDefaultEmailService() {
        return Optional.ofNullable(this.getDefaultEmailService(true));
    }

    public Optional<EmailService> getDefaultEmailService(Integration integration) {
        return this.getEmailService(integration);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public EmailService getEmailService(Integration integration, boolean checkConnection) {
        EmailService emailService = this.getEmailService(integration).orElseThrow(() -> this.emailConfigurationFail(null));
        if (checkConnection) {
            this.checkConnection(emailService);
        }
        return emailService;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public EmailService getDefaultEmailService(boolean checkConnection) {
        List integrationTypeIds = this.integrationTypeRepository.findAllByIntegrationGroup(IntegrationGroupEnum.NOTIFICATION).stream().map(IntegrationType::getId).collect(Collectors.toList());
        Integration integration = this.integrationRepository.findAllGlobalInIntegrationTypeIds(integrationTypeIds).stream().filter(Integration::isEnabled).findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Enabled email integration has not been found."}));
        EmailService emailService = this.getEmailService(integration).orElseThrow(() -> this.emailConfigurationFail(null));
        if (checkConnection) {
            this.checkConnection(emailService);
        }
        return emailService;
    }

    public void checkConnection(@Nullable EmailService service) {
        try {
            if (null == service) {
                throw this.emailConfigurationFail(null);
            }
            service.testConnection();
        }
        catch (Exception e) {
            throw this.emailConfigurationFail(e);
        }
    }

    private ReportPortalException emailConfigurationFail(Throwable e) {
        if (null != e) {
            LOGGER.error("Cannot send email to user", e);
        }
        return new ReportPortalException(ErrorType.EMAIL_CONFIGURATION_IS_INCORRECT, new Object[]{"Please configure email server in Report Portal settings."});
    }
}

