/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.config;

import com.epam.ta.reportportal.core.analyzer.pattern.CreatePatternTemplateHandler;
import com.epam.ta.reportportal.core.analyzer.pattern.impl.CreateRegexPatternTemplateHandler;
import com.epam.ta.reportportal.core.analyzer.pattern.impl.CreateStringPatternTemplateHandler;
import com.epam.ta.reportportal.core.analyzer.pattern.selector.PatternAnalysisSelector;
import com.epam.ta.reportportal.core.analyzer.pattern.selector.impl.RegexPatternAnalysisSelector;
import com.epam.ta.reportportal.core.analyzer.pattern.selector.impl.StringPartPatternAnalysisSelector;
import com.epam.ta.reportportal.entity.pattern.PatternTemplateType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class PatternAnalysisConfig
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean(value={"createPatternTemplateMapping"})
    public Map<PatternTemplateType, CreatePatternTemplateHandler> createPatternTemplateHandlerMapping() {
        return ImmutableMap.builder().put((Object)PatternTemplateType.STRING, (Object)((CreatePatternTemplateHandler)this.applicationContext.getBean(CreateStringPatternTemplateHandler.class))).put((Object)PatternTemplateType.REGEX, (Object)((CreatePatternTemplateHandler)this.applicationContext.getBean(CreateRegexPatternTemplateHandler.class))).build();
    }

    @Bean(value={"patternAnalysisSelectorMapping"})
    public Map<PatternTemplateType, PatternAnalysisSelector> patternAnalysisSelectorMapping() {
        return ImmutableMap.builder().put((Object)PatternTemplateType.STRING, (Object)((PatternAnalysisSelector)this.applicationContext.getBean(StringPartPatternAnalysisSelector.class))).put((Object)PatternTemplateType.REGEX, (Object)((PatternAnalysisSelector)this.applicationContext.getBean(RegexPatternAnalysisSelector.class))).build();
    }

    @Bean(value={"patternAnalysisTaskExecutor"})
    public TaskExecutor patternAnalysisTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(20);
        taskExecutor.setMaxPoolSize(100);
        taskExecutor.setQueueCapacity(600);
        taskExecutor.setThreadNamePrefix("pattern-analysis-task-exec");
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return taskExecutor;
    }
}

