/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.impl;

import com.epam.reportportal.extension.ReportPortalExtensionPoint;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.integration.ExecuteIntegrationHandler;
import com.epam.ta.reportportal.core.integration.util.IntegrationService;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ExecuteIntegrationHandlerImpl
implements ExecuteIntegrationHandler {
    private final Map<String, IntegrationService> integrationServiceMapping;
    private final IntegrationRepository integrationRepository;
    private final PluginBox pluginBox;
    private final IntegrationService basicIntegrationService;

    public ExecuteIntegrationHandlerImpl(IntegrationRepository integrationRepository, PluginBox pluginBox, @Qualifier(value="integrationServiceMapping") Map<String, IntegrationService> integrationServiceMapping, @Qualifier(value="basicIntegrationServiceImpl") IntegrationService basicIntegrationService) {
        this.integrationServiceMapping = integrationServiceMapping;
        this.integrationRepository = integrationRepository;
        this.pluginBox = pluginBox;
        this.basicIntegrationService = basicIntegrationService;
    }

    @Override
    public Object executeCommand(ReportPortalUser.ProjectDetails projectDetails, Long integrationId, String command, Map<String, ?> executionParams) {
        Integration integration = this.integrationRepository.findByIdAndProjectId(integrationId, projectDetails.getProjectId()).orElseGet(() -> (Integration)this.integrationRepository.findGlobalById(integrationId).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{integrationId})));
        IntegrationService integrationService = this.integrationServiceMapping.getOrDefault(integration.getType().getName(), this.basicIntegrationService);
        integrationService.decryptParams(integration);
        ReportPortalExtensionPoint pluginInstance = this.pluginBox.getInstance(integration.getType().getName(), ReportPortalExtensionPoint.class).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Plugin for '{}' isn't installed", (Object[])new Object[]{integration.getType().getName()}).get()}));
        Object response = Optional.ofNullable(pluginInstance.getCommandToExecute(command)).map(it -> it.executeCommand(integration, executionParams)).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Command '{}' is not found in plugin {}.", (Object[])new Object[]{command, integration.getType().getName()}).get()}));
        integrationService.encryptParams(integration);
        return response;
    }
}

