/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.jasper.impl;

import com.epam.ta.reportportal.core.jasper.JasperReportRender;
import com.epam.ta.reportportal.core.jasper.impl.AbstractJasperReportHandler;
import com.epam.ta.reportportal.core.jasper.util.ExportUtils;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.entity.jasper.ReportType;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="launchJasperReportHandler")
public class LaunchJasperReportHandler
extends AbstractJasperReportHandler<Launch> {
    private static final String UNSUPPORTED_REPORT_FORMAT_MESSAGE_EXCEPTION = "Report format - {} is not supported for launch reports.";
    private final Set<ReportFormat> availableReportFormats;
    private final JasperReportRender reportRender;

    @Autowired
    public LaunchJasperReportHandler(JasperReportRender reportRender) {
        super(UNSUPPORTED_REPORT_FORMAT_MESSAGE_EXCEPTION);
        this.reportRender = reportRender;
        this.availableReportFormats = Sets.immutableEnumSet((Enum)ReportFormat.HTML, (Enum[])new ReportFormat[]{ReportFormat.PDF, ReportFormat.XLS});
    }

    @Override
    public JasperPrint getJasperPrint(Map<String, Object> params, JRDataSource dataSource) {
        return this.reportRender.generateReportPrint(ReportType.LAUNCH, params, dataSource);
    }

    @Override
    public Map<String, Object> convertParams(Launch launch) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("LAUNCH_NAME", launch.getName() + " #" + launch.getNumber());
        params.put("LAUNCH_DESCRIPTION", launch.getDescription() == null ? "" : launch.getDescription());
        params.put("LAUNCH_TAGS", launch.getAttributes().stream().map(it -> it.getKey() == null ? it.getValue() : it.getKey().concat(it.getValue())).collect(Collectors.toList()));
        String duration = Optional.ofNullable(launch.getEndTime()).map(endTime -> ExportUtils.durationToShortDHMS(Duration.between(launch.getStartTime(), endTime))).orElse("");
        params.put("LAUNCH_DURATION", duration);
        Set statistics = launch.getStatistics();
        params.put("TOTAL", ExportUtils.getStatisticsCounter(statistics, "statistics$executions$total"));
        params.put("PASSED", ExportUtils.getStatisticsCounter(statistics, "statistics$executions$passed"));
        params.put("FAILED", ExportUtils.getStatisticsCounter(statistics, "statistics$executions$failed"));
        params.put("SKIPPED", ExportUtils.getStatisticsCounter(statistics, "statistics$executions$skipped"));
        params.put("AB", ExportUtils.getStatisticsCounter(statistics, "statistics$defects$automation_bug$total"));
        params.put("PB", ExportUtils.getStatisticsCounter(statistics, "statistics$defects$product_bug$total"));
        params.put("SI", ExportUtils.getStatisticsCounter(statistics, "statistics$defects$system_issue$total"));
        params.put("ND", ExportUtils.getStatisticsCounter(statistics, "statistics$defects$no_defect$total"));
        params.put("TI", ExportUtils.getStatisticsCounter(statistics, "statistics$defects$to_investigate$total"));
        return params;
    }

    @Override
    public Set<ReportFormat> getAvailableReportFormats() {
        return this.availableReportFormats;
    }
}

