/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.ta.reportportal.auth.acl.ShareableObjectsHandler;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.ProjectFilter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.WidgetCreatedEvent;
import com.epam.ta.reportportal.core.filter.UpdateUserFilterHandler;
import com.epam.ta.reportportal.core.widget.CreateWidgetHandler;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import com.epam.ta.reportportal.ws.converter.converters.WidgetConverter;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.WidgetRQ;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CreateWidgetHandlerImpl
implements CreateWidgetHandler {
    private final WidgetRepository widgetRepository;
    private final UserFilterRepository filterRepository;
    private final MessageBus messageBus;
    private final ShareableObjectsHandler aclHandler;
    private final UpdateUserFilterHandler updateUserFilterHandler;

    @Autowired
    public CreateWidgetHandlerImpl(WidgetRepository widgetRepository, UserFilterRepository filterRepository, MessageBus messageBus, ShareableObjectsHandler aclHandler, UpdateUserFilterHandler updateUserFilterHandler) {
        this.widgetRepository = widgetRepository;
        this.filterRepository = filterRepository;
        this.messageBus = messageBus;
        this.aclHandler = aclHandler;
        this.updateUserFilterHandler = updateUserFilterHandler;
    }

    @Override
    public EntryCreatedRS createWidget(WidgetRQ createWidgetRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        List<UserFilter> userFilter = this.getUserFilters(createWidgetRQ.getFilterIds(), projectDetails.getProjectId(), user.getUsername());
        BusinessRule.expect((Object)this.widgetRepository.existsByNameAndOwnerAndProjectId(createWidgetRQ.getName(), user.getUsername(), projectDetails.getProjectId()), BooleanUtils::isFalse).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{createWidgetRQ.getName()});
        Widget widget = new WidgetBuilder().addWidgetRq(createWidgetRQ).addProject(projectDetails.getProjectId()).addFilters(userFilter).addOwner(user.getUsername()).get();
        this.widgetRepository.save((Object)widget);
        this.aclHandler.initAcl(widget, user.getUsername(), projectDetails.getProjectId(), BooleanUtils.isTrue((Boolean)createWidgetRQ.getShare()));
        if (widget.isShared()) {
            Optional.ofNullable(widget.getFilters()).ifPresent(filters -> this.updateUserFilterHandler.updateSharing((Collection<UserFilter>)filters, projectDetails.getProjectId(), widget.isShared()));
        }
        this.messageBus.publishActivity(new WidgetCreatedEvent(WidgetConverter.TO_ACTIVITY_RESOURCE.apply(widget), user.getUserId(), user.getUsername()));
        return new EntryCreatedRS(widget.getId());
    }

    private List<UserFilter> getUserFilters(List<Long> filterIds, Long projectId, String username) {
        if (CollectionUtils.isNotEmpty(filterIds)) {
            String ids = filterIds.stream().map(String::valueOf).collect(Collectors.joining(","));
            Filter defaultFilter = new Filter(UserFilter.class, Condition.IN, false, ids, "id");
            List userFilters = this.filterRepository.getPermitted(ProjectFilter.of((Queryable)defaultFilter, (Long)projectId), Pageable.unpaged(), username).getContent();
            BusinessRule.expect((Object)userFilters, (Predicate)Predicates.not(List::isEmpty)).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{filterIds, projectId, username});
            return userFilters;
        }
        return Collections.emptyList();
    }
}

