/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler.subscriber.impl;

import com.epam.ta.reportportal.core.analyzer.auto.AnalyzerServiceAsync;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeCollectorFactory;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsMode;
import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.core.events.handler.subscriber.LaunchFinishedEventSubscriber;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.ws.model.project.AnalyzerConfig;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaunchAutoAnalysisSubscriber
implements LaunchFinishedEventSubscriber {
    private final AnalyzerServiceAsync analyzerServiceAsync;
    private final AnalyzeCollectorFactory analyzeCollectorFactory;
    private final LogIndexer logIndexer;

    @Autowired
    public LaunchAutoAnalysisSubscriber(AnalyzerServiceAsync analyzerServiceAsync, AnalyzeCollectorFactory analyzeCollectorFactory, LogIndexer logIndexer) {
        this.analyzerServiceAsync = analyzerServiceAsync;
        this.analyzeCollectorFactory = analyzeCollectorFactory;
        this.logIndexer = logIndexer;
    }

    @Override
    public void handleEvent(LaunchFinishedEvent launchFinishedEvent, Project project, Launch launch) {
        AnalyzerConfig analyzerConfig = AnalyzerUtils.getAnalyzerConfig(project);
        if (BooleanUtils.isTrue((Boolean)analyzerConfig.getIsAutoAnalyzerEnabled()) && this.analyzerServiceAsync.hasAnalyzers()) {
            List<Long> itemIds = this.analyzeCollectorFactory.getCollector(AnalyzeItemsMode.TO_INVESTIGATE).collectItems(project.getId(), launch.getId(), launchFinishedEvent.getUser());
            this.logIndexer.indexLaunchLogs(project.getId(), launch.getId(), analyzerConfig).join();
            this.analyzerServiceAsync.analyze(launch, itemIds, analyzerConfig).join();
            CompletableFuture.supplyAsync(() -> this.logIndexer.indexItemsLogs(project.getId(), launch.getId(), itemIds, analyzerConfig));
        } else {
            this.logIndexer.indexLaunchLogs(project.getId(), launch.getId(), analyzerConfig);
        }
    }

    public int getOrder() {
        return 1;
    }
}

