/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.TestItemService;
import com.epam.ta.reportportal.core.log.GetLogHandler;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.NestedItem;
import com.epam.ta.reportportal.entity.item.NestedStep;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.LogConverter;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.log.LogResource;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.stereotype.Service;

@Service
public class GetLogHandlerImpl
implements GetLogHandler {
    public static final String EXCLUDE_PASSED_LOGS = "excludePassedLogs";
    public static final String EXCLUDE_EMPTY_STEPS = "excludeEmptySteps";
    private final LogRepository logRepository;
    private final TestItemRepository testItemRepository;
    private final TestItemService testItemService;

    @Autowired
    public GetLogHandlerImpl(LogRepository logRepository, TestItemRepository testItemRepository, TestItemService testItemService) {
        this.logRepository = logRepository;
        this.testItemRepository = testItemRepository;
        this.testItemService = testItemService;
    }

    @Override
    public Iterable<LogResource> getLogs(ReportPortalUser.ProjectDetails projectDetails, Filter filterable, Pageable pageable) {
        Page logPage = this.logRepository.findByFilter((Queryable)filterable, pageable);
        return (Iterable)PagedResourcesAssembler.pageConverter(LogConverter.TO_RESOURCE).apply((Page<Log>)logPage);
    }

    @Override
    public long getPageNumber(Long logId, ReportPortalUser.ProjectDetails projectDetails, Filter filterable, Pageable pageable) {
        return this.logRepository.getPageNumber(logId, filterable, pageable).intValue();
    }

    @Override
    public LogResource getLog(String logId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Log log;
        try {
            log = this.findById(Long.parseLong(logId));
        }
        catch (NumberFormatException e) {
            log = this.findByUuid(logId);
        }
        this.validate(log, projectDetails);
        return LogConverter.TO_RESOURCE.apply(log);
    }

    @Override
    public Iterable<?> getNestedItems(Long parentId, ReportPortalUser.ProjectDetails projectDetails, Map<String, String> params, Queryable queryable, Pageable pageable) {
        TestItem parentItem = (TestItem)this.testItemRepository.findById((Object)parentId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{parentId}));
        Launch launch = this.testItemService.getEffectiveLaunch(parentItem);
        this.validate(launch, projectDetails);
        Boolean excludeEmptySteps = Optional.ofNullable(params.get(EXCLUDE_EMPTY_STEPS)).map(BooleanUtils::toBoolean).orElse(false);
        Boolean excludePassedLogs = Optional.ofNullable(params.get(EXCLUDE_PASSED_LOGS)).map(BooleanUtils::toBoolean).orElse(false);
        Page nestedItems = this.logRepository.findNestedItems(parentId, excludeEmptySteps.booleanValue(), this.isLogsExclusionRequired(parentItem, excludePassedLogs), queryable, pageable);
        List content = nestedItems.getContent();
        Map<String, List<NestedItem>> result = content.stream().collect(Collectors.groupingBy(NestedItem::getType));
        Map logMap = Optional.ofNullable(result.get("log")).map(logs -> this.logRepository.findAllById((Iterable)logs.stream().map(NestedItem::getId).collect(Collectors.toSet())).stream().collect(Collectors.toMap(Log::getId, l -> l))).orElseGet(Collections::emptyMap);
        queryable.getFilterConditions().add(this.getLaunchCondition(launch.getId()));
        queryable.getFilterConditions().add(this.getParentPathCondition(parentItem));
        Map nestedStepMap = Optional.ofNullable(result.get("item")).map(testItems -> this.testItemRepository.findAllNestedStepsByIds((Collection)testItems.stream().map(NestedItem::getId).collect(Collectors.toSet()), queryable, excludePassedLogs.booleanValue()).stream().collect(Collectors.toMap(NestedStep::getId, i -> i))).orElseGet(Collections::emptyMap);
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)content.size());
        content.forEach(nestedItem -> {
            if ("log".equals(nestedItem.getType())) {
                Optional.ofNullable((Log)logMap.get(nestedItem.getId())).map(LogConverter.TO_RESOURCE).ifPresent(resources::add);
            } else if ("item".equals(nestedItem.getType())) {
                Optional.ofNullable((NestedStep)nestedStepMap.get(nestedItem.getId())).map(TestItemConverter.TO_NESTED_STEP_RESOURCE).ifPresent(resources::add);
            }
        });
        return (Iterable)PagedResourcesAssembler.pageConverter().apply(PageableExecutionUtils.getPage((List)resources, (Pageable)nestedItems.getPageable(), () -> ((Page)nestedItems).getTotalElements()));
    }

    private void validate(Log log, ReportPortalUser.ProjectDetails projectDetails) {
        Long launchProjectId = Optional.ofNullable(log.getTestItem()).map(it -> this.testItemService.getEffectiveLaunch((TestItem)it).getProjectId()).orElseGet(() -> log.getLaunch().getProjectId());
        BusinessRule.expect((Object)launchProjectId, (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Log '{}' is not under '{}' project", (Object[])new Object[]{log.getId(), projectDetails.getProjectName()})});
    }

    private void validate(Launch launch, ReportPortalUser.ProjectDetails projectDetails) {
        BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Launch '{}' is not under '{}' project", (Object[])new Object[]{launch.getId(), projectDetails.getProjectName()})});
    }

    private Log findById(Long logId) {
        return (Log)this.logRepository.findById((Object)logId).orElseThrow(() -> new ReportPortalException(ErrorType.LOG_NOT_FOUND, new Object[]{logId}));
    }

    private Log findByUuid(String logId) {
        return (Log)this.logRepository.findByUuid(logId).orElseThrow(() -> new ReportPortalException(ErrorType.LOG_NOT_FOUND, new Object[]{logId}));
    }

    private FilterCondition getLaunchCondition(Long launchId) {
        return FilterCondition.builder().eq("launchId", String.valueOf(launchId)).build();
    }

    private FilterCondition getParentPathCondition(TestItem parent) {
        String pathValue = Optional.ofNullable(parent.getRetryOf()).flatMap(retryParentId -> Optional.ofNullable(parent.getParent()).map(retryParent -> retryParent.getPath() + "." + parent.getItemId())).orElse(parent.getPath());
        return FilterCondition.builder().withCondition(Condition.UNDER).withSearchCriteria("path").withValue(pathValue).build();
    }

    private boolean isLogsExclusionRequired(TestItem parent, boolean excludePassedLogs) {
        if (excludePassedLogs) {
            return Stream.of(StatusEnum.values()).filter(StatusEnum::isPositive).anyMatch(s -> s == parent.getItemResults().getStatus());
        }
        return false;
    }
}

