/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.launch.FinishLaunchHandler;
import com.epam.ta.reportportal.util.ReportingQueueService;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.launch.FinishLaunchRS;
import com.epam.ta.reportportal.ws.rabbit.RequestType;
import java.util.Map;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier(value="finishLaunchHandlerAsync")
public class FinishLaunchHandlerAsyncImpl
implements FinishLaunchHandler {
    @Autowired
    @Qualifier(value="rabbitTemplate")
    AmqpTemplate amqpTemplate;
    @Autowired
    private ReportingQueueService reportingQueueService;

    @Override
    public FinishLaunchRS finishLaunch(String launchId, FinishExecutionRQ request, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, String baseUrl) {
        this.amqpTemplate.convertAndSend("reporting", this.reportingQueueService.getReportingQueueKey(launchId), (Object)request, message -> {
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("requestType", RequestType.FINISH_LAUNCH);
            headers.put("username", user.getUsername());
            headers.put("projectName", projectDetails.getProjectName());
            headers.put("launchId", launchId);
            headers.put("baseUrl", baseUrl);
            return message;
        });
        FinishLaunchRS response = new FinishLaunchRS();
        response.setId(launchId);
        return response;
    }
}

