/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.LaunchFinishForcedEvent;
import com.epam.ta.reportportal.core.launch.StopLaunchHandler;
import com.epam.ta.reportportal.core.launch.util.LaunchValidator;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.model.BulkRQ;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class StopLaunchHandlerImpl
implements StopLaunchHandler {
    private static final String LAUNCH_STOP_DESCRIPTION = " stopped";
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final MessageBus messageBus;

    @Autowired
    public StopLaunchHandlerImpl(LaunchRepository launchRepository, TestItemRepository testItemRepository, MessageBus messageBus) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.messageBus = messageBus;
    }

    @Override
    public OperationCompletionRS stopLaunch(Long launchId, FinishExecutionRQ finishLaunchRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        LaunchValidator.validateRoles(launch, user, projectDetails);
        LaunchValidator.validate(launch, finishLaunchRQ);
        launch = new LaunchBuilder(launch).addDescription(Optional.ofNullable(finishLaunchRQ.getDescription()).orElse(Optional.ofNullable(launch.getDescription()).orElse("")).concat(LAUNCH_STOP_DESCRIPTION)).addStatus(Optional.ofNullable(finishLaunchRQ.getStatus()).orElse(StatusEnum.STOPPED.name())).addEndTime(Optional.ofNullable(finishLaunchRQ.getEndTime()).orElse(new Date())).addAttributes(finishLaunchRQ.getAttributes()).addAttribute(new ItemAttributeResource("status", "stopped")).get();
        this.launchRepository.save((Object)launch);
        this.testItemRepository.interruptInProgressItems(launch.getId());
        this.messageBus.publishActivity(new LaunchFinishForcedEvent(LaunchConverter.TO_ACTIVITY_RESOURCE.apply(launch), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Launch with ID = '" + launchId + "' successfully stopped.");
    }

    @Override
    public List<OperationCompletionRS> stopLaunch(BulkRQ<Long, FinishExecutionRQ> bulkRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        return bulkRQ.getEntities().entrySet().stream().map(entry -> this.stopLaunch((Long)entry.getKey(), (FinishExecutionRQ)entry.getValue(), projectDetails, user)).collect(Collectors.toList());
    }
}

