/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.ta.reportportal.auth.acl.ShareableObjectsHandler;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.indexer.IndexerStatusCache;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.NotificationsConfigUpdatedEvent;
import com.epam.ta.reportportal.core.events.activity.ProjectAnalyzerConfigEvent;
import com.epam.ta.reportportal.core.events.activity.ProjectIndexEvent;
import com.epam.ta.reportportal.core.events.activity.ProjectUpdatedEvent;
import com.epam.ta.reportportal.core.project.UpdateProjectHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.ProjectUserRepository;
import com.epam.ta.reportportal.dao.UserPreferenceRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.AnalyzeMode;
import com.epam.ta.reportportal.entity.enums.InterruptionJobDelay;
import com.epam.ta.reportportal.entity.enums.KeepLaunchDelay;
import com.epam.ta.reportportal.entity.enums.KeepLogsDelay;
import com.epam.ta.reportportal.entity.enums.KeepScreenshotsDelay;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.enums.ProjectType;
import com.epam.ta.reportportal.entity.enums.SendCase;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.user.ProjectUser;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.entity.user.UserType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.util.email.EmailRulesValidator;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.converter.converters.NotificationConfigConverter;
import com.epam.ta.reportportal.ws.converter.converters.ProjectActivityConverter;
import com.epam.ta.reportportal.ws.converter.converters.ProjectConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.activity.ProjectAttributesActivityResource;
import com.epam.ta.reportportal.ws.model.project.AssignUsersRQ;
import com.epam.ta.reportportal.ws.model.project.ProjectResource;
import com.epam.ta.reportportal.ws.model.project.UnassignUsersRQ;
import com.epam.ta.reportportal.ws.model.project.UpdateProjectRQ;
import com.epam.ta.reportportal.ws.model.project.config.ProjectConfigurationUpdate;
import com.epam.ta.reportportal.ws.model.project.email.ProjectNotificationConfigDTO;
import com.epam.ta.reportportal.ws.model.project.email.SenderCaseDTO;
import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.stereotype.Service;

@Service
public class UpdateProjectHandlerImpl
implements UpdateProjectHandler {
    private final ProjectRepository projectRepository;
    private final UserRepository userRepository;
    private final UserPreferenceRepository preferenceRepository;
    private final ProjectUserRepository projectUserRepository;
    private final MessageBus messageBus;
    private final MailServiceFactory mailServiceFactory;
    private final LaunchRepository launchRepository;
    private final AnalyzerStatusCache analyzerStatusCache;
    private final IndexerStatusCache indexerStatusCache;
    private final AnalyzerServiceClient analyzerServiceClient;
    private final LogIndexer logIndexer;
    private final ShareableObjectsHandler aclHandler;
    private final ProjectConverter projectConverter;

    @Autowired
    public UpdateProjectHandlerImpl(ProjectRepository projectRepository, UserRepository userRepository, UserPreferenceRepository preferenceRepository, MessageBus messageBus, ProjectUserRepository projectUserRepository, MailServiceFactory mailServiceFactory, LaunchRepository launchRepository, AnalyzerStatusCache analyzerStatusCache, IndexerStatusCache indexerStatusCache, AnalyzerServiceClient analyzerServiceClient, LogIndexer logIndexer, ShareableObjectsHandler aclHandler, ProjectConverter projectConverter) {
        this.projectRepository = projectRepository;
        this.userRepository = userRepository;
        this.preferenceRepository = preferenceRepository;
        this.messageBus = messageBus;
        this.projectUserRepository = projectUserRepository;
        this.mailServiceFactory = mailServiceFactory;
        this.launchRepository = launchRepository;
        this.analyzerStatusCache = analyzerStatusCache;
        this.indexerStatusCache = indexerStatusCache;
        this.analyzerServiceClient = analyzerServiceClient;
        this.logIndexer = logIndexer;
        this.aclHandler = aclHandler;
        this.projectConverter = projectConverter;
    }

    @Override
    public OperationCompletionRS updateProject(String projectName, UpdateProjectRQ updateProjectRQ, ReportPortalUser user) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        ProjectAttributesActivityResource before = ProjectActivityConverter.TO_ACTIVITY_RESOURCE.apply(project);
        this.updateProjectConfiguration(updateProjectRQ.getConfiguration(), project);
        this.updateProjectUserRoles(updateProjectRQ.getUserRoles(), project, user);
        this.projectRepository.save((Object)project);
        ProjectAttributesActivityResource after = ProjectActivityConverter.TO_ACTIVITY_RESOURCE.apply(project);
        this.messageBus.publishActivity(new ProjectUpdatedEvent(before, after, user.getUserId(), user.getUsername()));
        this.messageBus.publishActivity(new ProjectAnalyzerConfigEvent(before, after, user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Project with name = '" + project.getName() + "' is successfully updated.");
    }

    @Override
    public OperationCompletionRS updateProjectNotificationConfig(String projectName, ReportPortalUser user, ProjectNotificationConfigDTO updateProjectNotificationConfigRQ) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        ProjectResource before = this.projectConverter.TO_PROJECT_RESOURCE.apply(project);
        this.updateSenderCases(project, updateProjectNotificationConfigRQ.getSenderCases());
        project.getProjectAttributes().stream().filter(it -> it.getAttribute().getName().equalsIgnoreCase(ProjectAttributeEnum.NOTIFICATIONS_ENABLED.getAttribute())).findAny().ifPresent(pa -> pa.setValue(String.valueOf(updateProjectNotificationConfigRQ.isEnabled())));
        this.messageBus.publishActivity(new NotificationsConfigUpdatedEvent(before, updateProjectNotificationConfigRQ, user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Notification configuration of project - '" + projectName + "' is successfully updated.");
    }

    @Override
    public OperationCompletionRS unassignUsers(String projectName, UnassignUsersRQ unassignUsersRQ, ReportPortalUser user) {
        BusinessRule.expect((Object)unassignUsersRQ.getUsernames(), (Predicate)Predicates.not(List::isEmpty)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Request should contain at least one username."});
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        User modifier = (User)this.userRepository.findById((Object)user.getUserId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{user.getUsername()}));
        if (!UserRole.ADMINISTRATOR.equals((Object)modifier.getRole())) {
            BusinessRule.expect((Object)unassignUsersRQ.getUsernames(), (Predicate)Predicates.not((Predicate)Preconditions.contains((Predicate)Predicates.equalTo((Object)modifier.getLogin())))).verify(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"User should not unassign himself from project."});
        }
        List<ProjectUser> unassignedUsers = this.unassignUsers(unassignUsersRQ.getUsernames(), modifier, project, user);
        this.projectUserRepository.deleteAll(unassignedUsers);
        ProjectUtils.excludeProjectRecipients((Iterable)unassignedUsers.stream().map(ProjectUser::getUser).collect(Collectors.toSet()), (Project)project);
        unassignedUsers.forEach(it -> this.preferenceRepository.removeByProjectIdAndUserId(project.getId(), it.getUser().getId()));
        return new OperationCompletionRS("User(s) with username(s)='" + unassignUsersRQ.getUsernames() + "' was successfully un-assigned from project='" + project.getName() + "'");
    }

    @Override
    public OperationCompletionRS assignUsers(String projectName, AssignUsersRQ assignUsersRQ, ReportPortalUser user) {
        if (UserRole.ADMINISTRATOR.equals((Object)user.getUserRole())) {
            Project project = (Project)this.projectRepository.findByName(EntityUtils.normalizeId((String)projectName)).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{EntityUtils.normalizeId((String)projectName)}));
            List assignedUsernames = project.getUsers().stream().map(u -> u.getUser().getLogin()).collect(Collectors.toList());
            assignUsersRQ.getUserNames().forEach((name, role) -> {
                ProjectRole projectRole = (ProjectRole)ProjectRole.forName((String)role).orElseThrow(() -> new ReportPortalException(ErrorType.ROLE_NOT_FOUND, new Object[]{role}));
                this.assignUser((String)name, projectRole, assignedUsernames, project);
            });
        } else {
            BusinessRule.expect(assignUsersRQ.getUserNames().keySet(), (Predicate)Predicates.not((Predicate)Preconditions.contains((Predicate)Predicates.equalTo((Object)user.getUsername())))).verify(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"User should not assign himself to project."});
            ReportPortalUser.ProjectDetails projectDetails = ProjectExtractor.extractProjectDetails(user, projectName);
            Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{EntityUtils.normalizeId((String)projectName)}));
            List assignedUsernames = project.getUsers().stream().map(u -> u.getUser().getLogin()).collect(Collectors.toList());
            assignUsersRQ.getUserNames().forEach((name, role) -> {
                ProjectRole projectRole = (ProjectRole)ProjectRole.forName((String)role).orElseThrow(() -> new ReportPortalException(ErrorType.ROLE_NOT_FOUND, new Object[]{role}));
                ProjectRole modifierRole = projectDetails.getProjectRole();
                BusinessRule.expect((Object)modifierRole.sameOrHigherThan(projectRole), BooleanUtils::isTrue).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                this.assignUser((String)name, projectRole, assignedUsernames, project);
            });
        }
        return new OperationCompletionRS("User(s) with username='" + assignUsersRQ.getUserNames().keySet() + "' was successfully assigned to project='" + EntityUtils.normalizeId((String)projectName) + "'");
    }

    @Override
    public OperationCompletionRS indexProjectData(String projectName, ReportPortalUser user) {
        BusinessRule.expect((Object)this.analyzerServiceClient.hasClients(), Predicate.isEqual(true)).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"There are no analyzer deployed."});
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        BusinessRule.expect((Object)Optional.ofNullable((Boolean)this.indexerStatusCache.getIndexingStatus().getIfPresent((Object)project.getId())).orElse(false), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Index can not be removed until index generation proceeds."});
        Cache<Long, Long> analyzeStatus = this.analyzerStatusCache.getAnalyzeStatus("autoAnalyzer").orElseThrow(() -> new ReportPortalException(ErrorType.ANALYZER_NOT_FOUND, new Object[]{"autoAnalyzer"}));
        BusinessRule.expect((Object)analyzeStatus.asMap().containsValue(project.getId()), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Index can not be removed until auto-analysis proceeds."});
        List launches = this.launchRepository.findLaunchIdsByProjectId(project.getId());
        this.logIndexer.deleteIndex(project.getId());
        this.logIndexer.indexLaunchesLogs(project.getId(), launches, AnalyzerUtils.getAnalyzerConfig(project)).thenAcceptAsync(indexedCount -> this.mailServiceFactory.getDefaultEmailService(true).sendIndexFinishedEmail("Index generation has been finished", user.getEmail(), (Long)indexedCount));
        this.messageBus.publishActivity(new ProjectIndexEvent(project.getId(), project.getName(), user.getUserId(), user.getUsername(), true));
        return new OperationCompletionRS("Log indexing has been started");
    }

    private List<ProjectUser> unassignUsers(List<String> usernames, User modifier, Project project, ReportPortalUser user) {
        ArrayList unassignedUsers = Lists.newArrayListWithExpectedSize((int)usernames.size());
        if (modifier.getRole() == UserRole.ADMINISTRATOR) {
            usernames.forEach(username -> {
                User userForUnassign = (User)this.userRepository.findByLogin(username).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{username}));
                this.validateUnassigningUser(modifier, userForUnassign, project.getId(), project);
                unassignedUsers.add(this.unassignUser(project, (String)username, userForUnassign));
            });
        } else {
            ReportPortalUser.ProjectDetails projectDetails = ProjectExtractor.extractProjectDetails(user, project.getName());
            usernames.forEach(username -> {
                User userForUnassign = (User)this.userRepository.findByLogin(username).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{username}));
                ProjectUser projectUser = userForUnassign.getProjects().stream().filter(it -> Objects.equals(it.getProject().getId(), project.getId())).findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{userForUnassign.getLogin(), String.format("User not found in project %s", project.getName())}));
                BusinessRule.expect((Object)projectDetails.getProjectRole().sameOrHigherThan(projectUser.getProjectRole()), BooleanUtils::isTrue).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                this.validateUnassigningUser(modifier, userForUnassign, project.getId(), project);
                unassignedUsers.add(this.unassignUser(project, (String)username, userForUnassign));
            });
        }
        return unassignedUsers;
    }

    private ProjectUser unassignUser(Project project, String username, User userForUnassign) {
        ProjectUser projectUser = project.getUsers().stream().filter(it -> it.getUser().getLogin().equalsIgnoreCase(username)).findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{username}));
        project.getUsers().remove(projectUser);
        userForUnassign.getProjects().remove(projectUser);
        this.aclHandler.preventSharedObjects(project.getId(), username);
        return projectUser;
    }

    private void assignUser(String name, ProjectRole projectRole, List<String> assignedUsernames, Project project) {
        User modifyingUser = (User)this.userRepository.findByLogin(EntityUtils.normalizeId((String)name)).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{name}));
        BusinessRule.expect((Object)name, (Predicate)Predicates.not((Predicate)Predicates.in(assignedUsernames))).verify(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{Suppliers.formattedSupplier((String)"User '{}' cannot be assigned to project twice.", (Object[])new Object[]{name})});
        if (ProjectType.UPSA.equals((Object)project.getProjectType()) && UserType.UPSA.equals((Object)modifyingUser.getUserType())) {
            BusinessRule.fail().withError(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"Project and user has UPSA type!"});
        }
        ProjectUser projectUser = new ProjectUser();
        projectUser.setProjectRole(projectRole);
        projectUser.setUser(modifyingUser);
        projectUser.setProject(project);
        project.getUsers().add(projectUser);
        if (projectRole.sameOrHigherThan(ProjectRole.PROJECT_MANAGER)) {
            this.aclHandler.permitSharedObjects(project.getId(), name, BasePermission.ADMINISTRATION);
        } else {
            this.aclHandler.permitSharedObjects(project.getId(), name, BasePermission.READ);
        }
    }

    private void validateUnassigningUser(User modifier, User userForUnassign, Long projectId, Project project) {
        if (ProjectUtils.isPersonalForUser((ProjectType)project.getProjectType(), (String)project.getName(), (String)userForUnassign.getLogin())) {
            BusinessRule.fail().withError(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"Unable to unassign user from his personal project"});
        }
        if (ProjectType.UPSA.equals((Object)project.getProjectType()) && UserType.UPSA.equals((Object)userForUnassign.getUserType())) {
            BusinessRule.fail().withError(ErrorType.UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT, new Object[]{"Project and user has UPSA type!"});
        }
        if (!ProjectUtils.doesHaveUser((Project)project, (String)userForUnassign.getLogin())) {
            BusinessRule.fail().withError(ErrorType.USER_NOT_FOUND, new Object[]{userForUnassign.getLogin(), String.format("User not found in project %s", project.getName())});
        }
    }

    private void updateProjectUserRoles(Map<String, String> userRoles, Project project, ReportPortalUser user) {
        if (null != userRoles && !user.getUserRole().equals((Object)UserRole.ADMINISTRATOR)) {
            BusinessRule.expect((Object)userRoles.get(user.getUsername()), (Predicate)Predicates.isNull()).verify(ErrorType.UNABLE_TO_UPDATE_YOURSELF_ROLE, new Object[]{user.getUsername()});
        }
        if (MapUtils.isNotEmpty(userRoles)) {
            userRoles.forEach((key, value) -> {
                Optional newProjectRole = ProjectRole.forName((String)value);
                BusinessRule.expect((Object)newProjectRole, (Predicate)Predicates.isPresent()).verify(ErrorType.ROLE_NOT_FOUND, new Object[]{value});
                Optional<ProjectUser> updatingProjectUser = Optional.ofNullable(ProjectUtils.findUserConfigByLogin((Project)project, (String)key));
                BusinessRule.expect(updatingProjectUser, (Predicate)Predicates.isPresent()).verify(ErrorType.USER_NOT_FOUND, new Object[]{key});
                if (UserRole.ADMINISTRATOR != user.getUserRole()) {
                    ProjectRole updatingUserRole;
                    ProjectRole principalRole = ProjectExtractor.extractProjectDetails(user, project.getName()).getProjectRole();
                    if (principalRole.sameOrHigherThan(updatingUserRole = Optional.ofNullable(ProjectUtils.findUserConfigByLogin((Project)project, (String)key)).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{key})).getProjectRole())) {
                        BusinessRule.expect((Object)((ProjectRole)newProjectRole.get()), (Predicate)Preconditions.isLevelEnough((ProjectRole)principalRole)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                    } else {
                        BusinessRule.expect((Object)updatingUserRole, (Predicate)Preconditions.isLevelEnough((ProjectRole)principalRole)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
                    }
                }
                updatingProjectUser.get().setProjectRole((ProjectRole)newProjectRole.get());
            });
        }
    }

    private void updateProjectConfiguration(ProjectConfigurationUpdate configuration, Project project) {
        Optional.ofNullable(configuration).ifPresent(config -> Optional.ofNullable(config.getProjectAttributes()).ifPresent(attributes -> {
            this.verifyProjectAttributes((Map<String, String>)attributes);
            attributes.forEach((attribute, value) -> project.getProjectAttributes().stream().filter(it -> it.getAttribute().getName().equalsIgnoreCase((String)attribute)).findFirst().ifPresent(attr -> attr.setValue(value)));
        }));
    }

    private void verifyProjectAttributes(Map<String, String> attributes) {
        Set incompatibleAttributes = attributes.keySet().stream().filter(it -> !ProjectAttributeEnum.isPresent((String)it)).collect(Collectors.toSet());
        BusinessRule.expect(incompatibleAttributes, Set::isEmpty).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{incompatibleAttributes});
        Optional.ofNullable(attributes.get(ProjectAttributeEnum.KEEP_LOGS.getAttribute())).ifPresent(keepLogs -> BusinessRule.expect((Object)keepLogs, KeepLogsDelay::isPresent).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{keepLogs}));
        Optional.ofNullable(attributes.get(ProjectAttributeEnum.KEEP_LAUNCHES.getAttribute())).ifPresent(keepLaunches -> BusinessRule.expect((Object)keepLaunches, KeepLaunchDelay::isPresent).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{keepLaunches}));
        Optional.ofNullable(attributes.get(ProjectAttributeEnum.INTERRUPT_JOB_TIME.getAttribute())).ifPresent(interruptedJob -> BusinessRule.expect((Object)interruptedJob, InterruptionJobDelay::isPresent).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{interruptedJob}));
        Optional.ofNullable(attributes.get(ProjectAttributeEnum.KEEP_SCREENSHOTS.getAttribute())).ifPresent(keepScreenshots -> BusinessRule.expect((Object)keepScreenshots, KeepScreenshotsDelay::isPresent).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{keepScreenshots}));
        Optional.ofNullable(attributes.get(ProjectAttributeEnum.AUTO_ANALYZER_MODE.getAttribute())).ifPresent(analyzerMode -> BusinessRule.expect((Object)AnalyzeMode.fromString((String)analyzerMode), (Predicate)Predicates.isPresent()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{analyzerMode}));
    }

    private void updateSenderCases(Project project, List<SenderCaseDTO> cases) {
        project.getSenderCases().clear();
        if (CollectionUtils.isNotEmpty(cases)) {
            cases.forEach(sendCase -> {
                BusinessRule.expect((Object)SendCase.findByName((String)sendCase.getSendCase()).isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{sendCase.getSendCase()});
                BusinessRule.expect((Object)sendCase.getRecipients(), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Recipients list should not be null"});
                BusinessRule.expect((Object)sendCase.getRecipients().isEmpty(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Empty recipients list for email case '{}' ", (Object[])new Object[]{sendCase})});
                sendCase.setRecipients(sendCase.getRecipients().stream().map(it -> {
                    EmailRulesValidator.validateRecipient(project, it);
                    return it.trim();
                }).distinct().collect(Collectors.toList()));
                Optional.ofNullable(sendCase.getLaunchNames()).ifPresent(launchNames -> sendCase.setLaunchNames(launchNames.stream().map(name -> {
                    EmailRulesValidator.validateLaunchName(name);
                    return name.trim();
                }).distinct().collect(Collectors.toList())));
                Optional.ofNullable(sendCase.getAttributes()).ifPresent(attributes -> sendCase.setAttributes(attributes.stream().peek(attribute -> {
                    EmailRulesValidator.validateLaunchAttribute(attribute);
                    attribute.setValue(attribute.getValue().trim());
                }).collect(Collectors.toSet())));
            });
            Set withoutDuplicateCases = cases.stream().distinct().map(NotificationConfigConverter.TO_CASE_MODEL).peek(sc -> sc.setProject(project)).collect(Collectors.toSet());
            if (cases.size() != withoutDuplicateCases.size()) {
                BusinessRule.fail().withError(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Project email settings contain duplicate cases"});
            }
            project.getSenderCases().addAll(withoutDuplicateCases);
        }
    }
}

