/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class PageUtil {
    private static final int DEFAULT_PAGE_SIZE = 50;

    private PageUtil() {
    }

    public static <T> void iterateOverPages(Function<Pageable, Page<T>> getFunc, Consumer<List<T>> consumer) {
        PageUtil.iterateOverPages(50, getFunc, consumer);
    }

    public static <T> void iterateOverPages(int pageSize, Function<Pageable, Page<T>> getFunc, Consumer<List<T>> consumer) {
        Page<T> pageData = getFunc.apply((Pageable)PageRequest.of((int)0, (int)pageSize));
        List content = pageData.getContent();
        consumer.accept(content);
        while (!pageData.isLast()) {
            pageData = getFunc.apply(pageData.nextPageable());
            consumer.accept(pageData.getContent());
        }
    }
}

