/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.entity.item.issue.IssueGroup;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.project.Project;
import java.util.function.Supplier;

public class IssueTypeBuilder
implements Supplier<IssueType> {
    private IssueType issueType;

    public IssueTypeBuilder() {
        this.issueType = new IssueType();
    }

    public IssueTypeBuilder(IssueType issueType) {
        this.issueType = issueType;
    }

    public IssueTypeBuilder addLocator(String locator) {
        this.issueType.setLocator(locator);
        return this;
    }

    public IssueTypeBuilder addIssueGroup(IssueGroup issueGroup) {
        this.issueType.setIssueGroup(issueGroup);
        return this;
    }

    public IssueTypeBuilder addLongName(String longName) {
        this.issueType.setLongName(longName);
        return this;
    }

    public IssueTypeBuilder addShortName(String shortName) {
        this.issueType.setShortName(shortName.toUpperCase());
        return this;
    }

    public IssueTypeBuilder addHexColor(String color) {
        this.issueType.setHexColor(color);
        return this;
    }

    public IssueTypeBuilder addProject(Project project) {
        return this;
    }

    @Override
    public IssueType get() {
        return this.issueType;
    }
}

