/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl;

import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.ws.model.analyzer.IndexLog;
import com.epam.ta.reportportal.ws.model.analyzer.IndexTestItem;
import com.epam.ta.reportportal.ws.model.analyzer.RelevantItemInfo;
import com.epam.ta.reportportal.ws.model.project.AnalyzerConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalyzerUtils {
    private static Function<Log, IndexLog> TO_INDEX_LOG = log -> {
        IndexLog indexLog = new IndexLog();
        indexLog.setLogId(log.getId());
        if (log.getLogLevel() != null) {
            indexLog.setLogLevel(log.getLogLevel().intValue());
        }
        indexLog.setMessage(log.getLogMessage());
        return indexLog;
    };
    public static final Function<TestItem, RelevantItemInfo> TO_RELEVANT_ITEM_INFO = item -> {
        RelevantItemInfo relevantItemInfo = new RelevantItemInfo();
        relevantItemInfo.setItemId(String.valueOf(item.getItemId()));
        relevantItemInfo.setPath(item.getPath());
        relevantItemInfo.setLaunchId(String.valueOf(item.getLaunchId()));
        return relevantItemInfo;
    };

    private AnalyzerUtils() {
    }

    public static IndexTestItem fromTestItem(TestItem testItem, List<Log> logs) {
        IndexTestItem indexTestItem = new IndexTestItem();
        indexTestItem.setTestItemId(testItem.getItemId());
        indexTestItem.setUniqueId(testItem.getUniqueId());
        indexTestItem.setStartTime(testItem.getStartTime());
        indexTestItem.setTestCaseHash(testItem.getTestCaseHash());
        if (testItem.getItemResults().getIssue() != null) {
            indexTestItem.setIssueTypeLocator(testItem.getItemResults().getIssue().getIssueType().getLocator());
            indexTestItem.setAutoAnalyzed(testItem.getItemResults().getIssue().getAutoAnalyzed().booleanValue());
        }
        if (!logs.isEmpty()) {
            indexTestItem.setLogs(logs.stream().filter(it -> StringUtils.isNotEmpty((CharSequence)it.getLogMessage())).map(TO_INDEX_LOG).collect(Collectors.toSet()));
        }
        return indexTestItem;
    }

    public static AnalyzerConfig getAnalyzerConfig(Project project) {
        Map configParameters = ProjectUtils.getConfigParameters((Set)project.getProjectAttributes());
        AnalyzerConfig analyzerConfig = new AnalyzerConfig();
        analyzerConfig.setIsAutoAnalyzerEnabled(Boolean.valueOf(BooleanUtils.toBoolean((String)((String)configParameters.get(ProjectAttributeEnum.AUTO_ANALYZER_ENABLED.getAttribute())))));
        analyzerConfig.setMinShouldMatch(Integer.valueOf(Optional.ofNullable((String)configParameters.get(ProjectAttributeEnum.MIN_SHOULD_MATCH.getAttribute())).orElse(ProjectAttributeEnum.MIN_SHOULD_MATCH.getDefaultValue())));
        analyzerConfig.setNumberOfLogLines(Integer.valueOf(Optional.ofNullable((String)configParameters.get(ProjectAttributeEnum.NUMBER_OF_LOG_LINES.getAttribute())).orElse(ProjectAttributeEnum.NUMBER_OF_LOG_LINES.getDefaultValue())));
        analyzerConfig.setIndexingRunning(BooleanUtils.toBoolean((String)((String)configParameters.get(ProjectAttributeEnum.INDEXING_RUNNING.getAttribute()))));
        analyzerConfig.setAnalyzerMode((String)configParameters.get(ProjectAttributeEnum.AUTO_ANALYZER_MODE.getAttribute()));
        return analyzerConfig;
    }
}

