/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.ReportingQueueService;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.rabbit.RequestType;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier(value="finishTestItemHandlerAsync")
public class FinishTestItemHandlerAsyncImpl
implements FinishTestItemHandler {
    @Autowired
    @Qualifier(value="rabbitTemplate")
    AmqpTemplate amqpTemplate;
    @Autowired
    private ReportingQueueService reportingQueueService;

    @Override
    public OperationCompletionRS finishTestItem(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, String testItemId, FinishTestItemRQ request) {
        this.amqpTemplate.convertAndSend("reporting", this.reportingQueueService.getReportingQueueKey(Optional.ofNullable(request.getLaunchUuid()).filter(StringUtils::isNotEmpty).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launch UUID should not be null or empty."}))), (Object)request, message -> {
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("requestType", RequestType.FINISH_TEST);
            headers.put("username", user.getUsername());
            headers.put("projectName", projectDetails.getProjectName());
            headers.put("itemId", testItemId);
            return message;
        });
        return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Accepted finish request for test item ID = {}", (Object[])new Object[]{testItemId}).get());
    }
}

