/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.TestItemStatusChangedEvent;
import com.epam.ta.reportportal.core.events.item.ItemFinishedEvent;
import com.epam.ta.reportportal.core.hierarchy.FinishHierarchyHandler;
import com.epam.ta.reportportal.core.item.ExternalTicketHandler;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.core.item.impl.retry.RetriesHandler;
import com.epam.ta.reportportal.core.item.impl.status.ChangeStatusHandler;
import com.epam.ta.reportportal.core.item.impl.status.StatusChangingStrategy;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.TestItemResults;
import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.Predicates;
import com.epam.ta.reportportal.ws.converter.builders.TestItemBuilder;
import com.epam.ta.reportportal.ws.converter.converters.IssueConverter;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.activity.TestItemActivityResource;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Primary
@Transactional
class FinishTestItemHandlerImpl
implements FinishTestItemHandler {
    private final TestItemRepository testItemRepository;
    private final IssueTypeHandler issueTypeHandler;
    private final FinishHierarchyHandler<TestItem> finishHierarchyHandler;
    private final LogIndexer logIndexer;
    private final Map<StatusEnum, StatusChangingStrategy> statusChangingStrategyMapping;
    private final IssueEntityRepository issueEntityRepository;
    private final LogRepository logRepository;
    private final LaunchRepository launchRepository;
    private final ChangeStatusHandler changeStatusHandler;
    private final RetriesHandler retriesHandler;
    private final ApplicationEventPublisher eventPublisher;
    private final MessageBus messageBus;
    private final ExternalTicketHandler externalTicketHandler;

    @Autowired
    FinishTestItemHandlerImpl(TestItemRepository testItemRepository, IssueTypeHandler issueTypeHandler, @Qualifier(value="finishTestItemHierarchyHandler") FinishHierarchyHandler<TestItem> finishHierarchyHandler, LogIndexer logIndexer, Map<StatusEnum, StatusChangingStrategy> statusChangingStrategyMapping, IssueEntityRepository issueEntityRepository, LogRepository logRepository, ChangeStatusHandler changeStatusHandler, ApplicationEventPublisher eventPublisher, LaunchRepository launchRepository, RetriesHandler retriesHandler, MessageBus messageBus, ExternalTicketHandler externalTicketHandler) {
        this.testItemRepository = testItemRepository;
        this.issueTypeHandler = issueTypeHandler;
        this.finishHierarchyHandler = finishHierarchyHandler;
        this.logIndexer = logIndexer;
        this.statusChangingStrategyMapping = statusChangingStrategyMapping;
        this.issueEntityRepository = issueEntityRepository;
        this.logRepository = logRepository;
        this.launchRepository = launchRepository;
        this.changeStatusHandler = changeStatusHandler;
        this.eventPublisher = eventPublisher;
        this.retriesHandler = retriesHandler;
        this.messageBus = messageBus;
        this.externalTicketHandler = externalTicketHandler;
    }

    @Override
    public OperationCompletionRS finishTestItem(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, String testItemId, FinishTestItemRQ finishExecutionRQ) {
        boolean handleRetries;
        TestItem testItem = (TestItem)this.testItemRepository.findByUuid(testItemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItemId}));
        Launch launch = this.retrieveLaunch(testItem);
        TestItemResults testItemResults = this.processItemResults(user, projectDetails, launch, testItem, finishExecutionRQ, testItem.isHasChildren());
        testItem = new TestItemBuilder(testItem).addDescription(finishExecutionRQ.getDescription()).addTestCaseId(finishExecutionRQ.getTestCaseId()).addAttributes(finishExecutionRQ.getAttributes()).addTestItemResults(testItemResults).get();
        this.testItemRepository.save((Object)testItem);
        boolean bl = handleRetries = !testItem.isHasChildren() && (BooleanUtils.toBoolean((Boolean)finishExecutionRQ.isRetry()) || StringUtils.isNotBlank((CharSequence)finishExecutionRQ.getRetryOf()));
        if (handleRetries) {
            this.retriesHandler.handleRetries(launch, testItem, finishExecutionRQ.getRetryOf());
        }
        return new OperationCompletionRS("TestItem with ID = '" + testItemId + "' successfully finished.");
    }

    private TestItemResults processItemResults(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, Launch launch, TestItem testItem, FinishTestItemRQ finishTestItemRQ, boolean hasChildren) {
        this.validateRoles(user, projectDetails, launch);
        this.verifyTestItem(testItem, StatusEnum.fromValue((String)finishTestItemRQ.getStatus()), testItem.isHasChildren());
        TestItemResults testItemResults = hasChildren ? this.processParentItemResult(testItem, finishTestItemRQ, launch, user, projectDetails) : this.processChildItemResult(testItem, finishTestItemRQ, user, projectDetails, launch);
        testItemResults.setEndTime((LocalDateTime)EntityUtils.TO_LOCAL_DATE_TIME.apply(finishTestItemRQ.getEndTime()));
        return testItemResults;
    }

    private Launch retrieveLaunch(TestItem testItem) {
        return (Launch)Optional.ofNullable(testItem.getRetryOf()).map(retryParentId -> {
            TestItem retryParent = (TestItem)this.testItemRepository.findById(retryParentId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{testItem.getRetryOf()}));
            return this.getLaunch(retryParent);
        }).orElseGet(() -> this.getLaunch(testItem)).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[0]));
    }

    private Optional<Launch> getLaunch(TestItem testItem) {
        return Optional.ofNullable(testItem.getLaunchId()).map(arg_0 -> ((LaunchRepository)this.launchRepository).findByIdForUpdate(arg_0)).orElseGet(() -> Optional.ofNullable(testItem.getParent()).map(TestItem::getLaunchId).map(arg_0 -> ((LaunchRepository)this.launchRepository).findByIdForUpdate(arg_0)).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[0])));
    }

    private void verifyTestItem(TestItem testItem, Optional<StatusEnum> actualStatus, boolean hasChildren) {
        BusinessRule.expect((Object)(!actualStatus.isPresent() && !hasChildren ? 1 : 0), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.AMBIGUOUS_TEST_ITEM_STATUS, new Object[]{Suppliers.formattedSupplier((String)"There is no status provided from request and there are no descendants to check statistics for test item id '{}'", (Object[])new Object[]{testItem.getItemId()})});
    }

    private void validateRoles(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, Launch launch) {
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            if (!launch.isRerun() && projectDetails.getProjectRole().lowerThan(ProjectRole.PROJECT_MANAGER)) {
                BusinessRule.expect((Object)user.getUserId(), Predicate.isEqual(launch.getUserId())).verify(ErrorType.FINISH_ITEM_NOT_ALLOWED, new Object[]{"You are not a launch owner."});
            }
        }
    }

    private TestItemResults processParentItemResult(TestItem testItem, FinishTestItemRQ finishTestItemRQ, Launch launch, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        TestItemResults testItemResults = testItem.getItemResults();
        Optional actualStatus = StatusEnum.fromValue((String)finishTestItemRQ.getStatus());
        if (this.testItemRepository.hasItemsInStatusByParent(testItem.getItemId(), testItem.getPath(), new String[]{StatusEnum.IN_PROGRESS.name()})) {
            this.finishDescendants(testItem, actualStatus.orElse(StatusEnum.INTERRUPTED), finishTestItemRQ.getEndTime(), user, projectDetails);
            testItemResults.setStatus(this.resolveStatus(testItem.getItemId()));
        } else {
            testItemResults.setStatus(actualStatus.orElseGet(() -> this.resolveStatus(testItem.getItemId())));
        }
        testItem.getAttributes().removeIf(attribute -> "status".equalsIgnoreCase(attribute.getKey()) && "interrupted".equalsIgnoreCase(attribute.getValue()));
        this.changeStatusHandler.changeParentStatus(testItem.getItemId(), projectDetails.getProjectId(), user);
        this.changeStatusHandler.changeLaunchStatus(launch);
        return testItemResults;
    }

    private TestItemResults processChildItemResult(TestItem testItem, FinishTestItemRQ finishTestItemRQ, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, Launch launch) {
        TestItemResults testItemResults = testItem.getItemResults();
        Optional actualStatus = StatusEnum.fromValue((String)finishTestItemRQ.getStatus());
        Optional<IssueEntity> resolvedIssue = this.resolveIssue(user, actualStatus.orElse(StatusEnum.INTERRUPTED), testItem, finishTestItemRQ.getIssue(), projectDetails.getProjectId());
        if (testItemResults.getStatus() == StatusEnum.IN_PROGRESS) {
            testItemResults.setStatus(actualStatus.orElse(StatusEnum.INTERRUPTED));
            resolvedIssue.ifPresent(issue -> {
                issue.setTestItemResults(testItemResults);
                this.issueEntityRepository.save(issue);
                testItemResults.setIssue(issue);
            });
            if (Objects.isNull(testItem.getRetryOf())) {
                this.changeStatusHandler.changeParentStatus(testItem.getItemId(), projectDetails.getProjectId(), user);
                this.changeStatusHandler.changeLaunchStatus(launch);
            }
        } else {
            this.updateFinishedItem(testItemResults, actualStatus.orElse(StatusEnum.INTERRUPTED), resolvedIssue, testItem, user, projectDetails.getProjectId());
        }
        testItem.getAttributes().removeIf(attribute -> "status".equalsIgnoreCase(attribute.getKey()) && "interrupted".equalsIgnoreCase(attribute.getValue()));
        return testItemResults;
    }

    private void finishDescendants(TestItem testItem, StatusEnum status, Date endTime, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        if (this.testItemRepository.hasItemsInStatusByParent(testItem.getItemId(), testItem.getPath(), new String[]{StatusEnum.IN_PROGRESS.name()})) {
            this.finishHierarchyHandler.finishDescendants(testItem, status, endTime, user, projectDetails);
        }
    }

    private StatusEnum resolveStatus(Long itemId) {
        return this.testItemRepository.hasDescendantsNotInStatus(itemId, new String[]{StatusEnum.PASSED.name(), StatusEnum.INFO.name(), StatusEnum.WARN.name()}) ? StatusEnum.FAILED : StatusEnum.PASSED;
    }

    private boolean isIssueRequired(TestItem testItem, StatusEnum status) {
        return Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.FAILED, StatusEnum.SKIPPED}).test(status) && !Optional.ofNullable(testItem.getRetryOf()).isPresent() && testItem.isHasStats();
    }

    private Optional<IssueEntity> resolveIssue(ReportPortalUser user, StatusEnum status, TestItem testItem, @Nullable Issue issue, Long projectId) {
        if (this.isIssueRequired(testItem, status)) {
            return Optional.ofNullable(issue).map(is -> {
                String locator = is.getIssueType();
                if (!TestItemIssueGroup.NOT_ISSUE_FLAG.getValue().equalsIgnoreCase(locator)) {
                    IssueType issueType = this.issueTypeHandler.defineIssueType(projectId, locator);
                    IssueEntity issueEntity = IssueConverter.TO_ISSUE.apply((Issue)is);
                    issueEntity.setIssueType(issueType);
                    if (!CollectionUtils.isEmpty((Collection)issue.getExternalSystemIssues())) {
                        this.externalTicketHandler.linkExternalTickets(user.getUsername(), Lists.newArrayList((Object[])new IssueEntity[]{issueEntity}), new ArrayList<Issue.ExternalSystemIssue>(issue.getExternalSystemIssues()));
                    }
                    return Optional.of(issueEntity);
                }
                return Optional.empty();
            }).orElseGet(() -> {
                IssueEntity issueEntity = new IssueEntity();
                IssueType toInvestigate = this.issueTypeHandler.defineIssueType(projectId, TestItemIssueGroup.TO_INVESTIGATE.getLocator());
                issueEntity.setIssueType(toInvestigate);
                return Optional.of(issueEntity);
            });
        }
        return Optional.empty();
    }

    private void updateFinishedItem(TestItemResults testItemResults, StatusEnum actualStatus, Optional<IssueEntity> resolvedIssue, TestItem testItem, ReportPortalUser user, Long projectId) {
        resolvedIssue.ifPresent(issue -> this.deleteOldIssueIndex(actualStatus, testItem, testItemResults, projectId));
        if (testItemResults.getStatus() != actualStatus) {
            TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply(testItem, projectId);
            Optional<StatusChangingStrategy> statusChangingStrategy = Optional.ofNullable(this.statusChangingStrategyMapping.get(actualStatus));
            if (statusChangingStrategy.isPresent()) {
                statusChangingStrategy.get().changeStatus(testItem, actualStatus, user);
            } else {
                testItemResults.setStatus(actualStatus);
            }
            this.publishUpdateActivity(before, TestItemConverter.TO_ACTIVITY_RESOURCE.apply(testItem, projectId), user);
        }
        resolvedIssue.ifPresent(issue -> {
            this.updateItemIssue(testItemResults, (IssueEntity)issue);
            if (Predicates.ITEM_CAN_BE_INDEXED.test(testItem)) {
                this.eventPublisher.publishEvent((Object)new ItemFinishedEvent(testItem.getItemId(), testItem.getLaunchId(), projectId));
            }
        });
    }

    private void publishUpdateActivity(TestItemActivityResource before, TestItemActivityResource after, ReportPortalUser user) {
        this.messageBus.publishActivity(new TestItemStatusChangedEvent(before, after, user.getUserId(), user.getUsername()));
    }

    private void deleteOldIssueIndex(StatusEnum actualStatus, TestItem testItem, TestItemResults testItemResults, Long projectId) {
        if (actualStatus == StatusEnum.PASSED || Predicates.ITEM_CAN_BE_INDEXED.test(testItem)) {
            Optional.ofNullable(testItemResults.getIssue()).ifPresent(issue -> this.logIndexer.cleanIndex(projectId, this.logRepository.findIdsUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(testItem.getLaunchId(), Collections.singletonList(testItem.getItemId()), LogLevel.ERROR.toInt())));
        }
    }

    private void updateItemIssue(TestItemResults testItemResults, IssueEntity resolvedIssue) {
        Optional.ofNullable(testItemResults.getIssue()).ifPresent(entity -> {
            entity.setTestItemResults(null);
            this.issueEntityRepository.delete(entity);
            testItemResults.setIssue(null);
        });
        resolvedIssue.setTestItemResults(testItemResults);
        this.issueEntityRepository.save((Object)resolvedIssue);
        testItemResults.setIssue(resolvedIssue);
    }
}

