/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.UserCreatedEvent;
import com.epam.ta.reportportal.core.integration.GetIntegrationHandler;
import com.epam.ta.reportportal.core.user.CreateUserHandler;
import com.epam.ta.reportportal.core.user.impl.SaveDefaultProjectService;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.RestorePasswordBidRepository;
import com.epam.ta.reportportal.dao.UserCreationBidRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.enums.IntegrationGroupEnum;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.user.ProjectUser;
import com.epam.ta.reportportal.entity.user.RestorePasswordBid;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserCreationBid;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.entity.user.UserType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.Predicates;
import com.epam.ta.reportportal.util.UserUtils;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.converter.converters.RestorePasswordBidConverter;
import com.epam.ta.reportportal.ws.converter.converters.UserCreationBidConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.YesNoRS;
import com.epam.ta.reportportal.ws.model.activity.UserActivityResource;
import com.epam.ta.reportportal.ws.model.user.CreateUserBidRS;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQ;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQConfirm;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQFull;
import com.epam.ta.reportportal.ws.model.user.CreateUserRS;
import com.epam.ta.reportportal.ws.model.user.ResetPasswordRQ;
import com.epam.ta.reportportal.ws.model.user.RestorePasswordRQ;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class CreateUserHandlerImpl
implements CreateUserHandler {
    private final UserRepository userRepository;
    private final ProjectRepository projectRepository;
    private final MailServiceFactory emailServiceFactory;
    private final UserCreationBidRepository userCreationBidRepository;
    private final RestorePasswordBidRepository restorePasswordBidRepository;
    private final MessageBus messageBus;
    private final SaveDefaultProjectService saveDefaultProjectService;
    private final GetIntegrationHandler getIntegrationHandler;
    private final ThreadPoolTaskExecutor emailExecutorService;
    private final PasswordEncoder passwordEncoder;

    @Autowired
    public CreateUserHandlerImpl(PasswordEncoder passwordEncoder, UserRepository userRepository, ProjectRepository projectRepository, MailServiceFactory emailServiceFactory, UserCreationBidRepository userCreationBidRepository, RestorePasswordBidRepository restorePasswordBidRepository, MessageBus messageBus, SaveDefaultProjectService saveDefaultProjectService, GetIntegrationHandler getIntegrationHandler, ThreadPoolTaskExecutor emailExecutorService) {
        this.passwordEncoder = passwordEncoder;
        this.userRepository = userRepository;
        this.projectRepository = projectRepository;
        this.emailServiceFactory = emailServiceFactory;
        this.userCreationBidRepository = userCreationBidRepository;
        this.restorePasswordBidRepository = restorePasswordBidRepository;
        this.messageBus = messageBus;
        this.saveDefaultProjectService = saveDefaultProjectService;
        this.getIntegrationHandler = getIntegrationHandler;
        this.emailExecutorService = emailExecutorService;
    }

    @Override
    public CreateUserRS createUserByAdmin(CreateUserRQFull request, ReportPortalUser creator, String basicUrl) {
        User administrator = (User)this.userRepository.findByLogin(creator.getUsername()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{creator.getUsername()}));
        BusinessRule.expect((Object)administrator.getRole(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)UserRole.ADMINISTRATOR)).verify(ErrorType.ACCESS_DENIED, new Object[]{Suppliers.formattedSupplier((String)"Only administrator can create new user. Your role is - {}", (Object[])new Object[]{administrator.getRole()})});
        request.setLogin(this.normalizeAndValidateLogin(request.getLogin()));
        request.setEmail(this.normalizeAndValidateEmail(request.getEmail()));
        request.setPassword(this.passwordEncoder.encode((CharSequence)request.getPassword()));
        Pair<UserActivityResource, CreateUserRS> pair = this.saveDefaultProjectService.saveDefaultProject(request, basicUrl);
        UserCreatedEvent userCreatedEvent = new UserCreatedEvent((UserActivityResource)pair.getKey(), creator.getUserId(), creator.getUsername());
        this.messageBus.publishActivity(userCreatedEvent);
        return (CreateUserRS)pair.getValue();
    }

    @Override
    public CreateUserBidRS createUserBid(CreateUserRQ request, ReportPortalUser loggedInUser, String emailURL) {
        Project defaultProject = (Project)this.projectRepository.findByName(EntityUtils.normalizeId((String)request.getDefaultProject())).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{request.getDefaultProject()}));
        this.userRepository.findById((Object)loggedInUser.getUserId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{loggedInUser.getUsername()}));
        Integration integration = this.getIntegrationHandler.getEnabledByProjectIdOrGlobalAndIntegrationGroup(defaultProject.getId(), IntegrationGroupEnum.NOTIFICATION).orElseThrow(() -> new ReportPortalException(ErrorType.EMAIL_CONFIGURATION_IS_INCORRECT, new Object[]{"Please configure email server in Report Portal settings."}));
        request.setEmail(this.normalizeAndValidateEmail(request.getEmail()));
        if (loggedInUser.getUserRole() != UserRole.ADMINISTRATOR) {
            ProjectUser projectUser = ProjectUtils.findUserConfigByLogin((Project)defaultProject, (String)loggedInUser.getUsername());
            BusinessRule.expect((Object)projectUser, (Predicate)com.epam.ta.reportportal.commons.Predicates.not((Predicate)com.epam.ta.reportportal.commons.Predicates.isNull())).verify(ErrorType.ACCESS_DENIED, new Object[]{Suppliers.formattedSupplier((String)"'{}' is not your project", (Object[])new Object[]{defaultProject.getName()})});
            BusinessRule.expect((Object)projectUser.getProjectRole(), Predicate.isEqual(ProjectRole.PROJECT_MANAGER)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        request.setRole(((ProjectRole)ProjectRole.forName((String)request.getRole()).orElseThrow(() -> new ReportPortalException(ErrorType.ROLE_NOT_FOUND, new Object[]{request.getRole()}))).name());
        UserCreationBid bid = UserCreationBidConverter.TO_USER.apply(request, defaultProject);
        try {
            this.userCreationBidRepository.save((Object)bid);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error while user creation bid registering.", (Throwable)e);
        }
        StringBuilder emailLink = new StringBuilder(emailURL).append("/ui/#registration?uuid=").append(bid.getUuid());
        this.emailExecutorService.execute(() -> this.emailServiceFactory.getEmailService(integration, false).sendCreateUserConfirmationEmail("User registration confirmation", new String[]{bid.getEmail()}, emailLink.toString()));
        CreateUserBidRS response = new CreateUserBidRS();
        String msg = "Bid for user creation with email '" + request.getEmail() + "' is successfully registered. Confirmation info will be send on provided email. Expiration: 1 day.";
        response.setMessage(msg);
        response.setBid(bid.getUuid());
        response.setBackLink(emailLink.toString());
        return response;
    }

    @Override
    public CreateUserRS createUser(CreateUserRQConfirm request, String uuid) {
        UserCreationBid bid = (UserCreationBid)this.userCreationBidRepository.findById((Object)uuid).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{"Impossible to register user. UUID expired or already registered."}));
        CreateUserRQFull createUserRQFull = new CreateUserRQFull();
        String login = this.normalizeAndValidateLogin(request.getLogin());
        createUserRQFull.setLogin(login);
        String email = this.normalizeAndValidateEmail(request.getEmail());
        BusinessRule.expect((Object)email, Predicate.isEqual(bid.getEmail())).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Email from bid not match."});
        createUserRQFull.setEmail(email);
        createUserRQFull.setFullName(request.getFullName());
        createUserRQFull.setPassword(request.getPassword());
        createUserRQFull.setDefaultProject(bid.getDefaultProject().getName());
        createUserRQFull.setAccountRole(UserRole.USER.name());
        createUserRQFull.setProjectRole(bid.getRole());
        createUserRQFull.setPassword(this.passwordEncoder.encode((CharSequence)request.getPassword()));
        Pair<UserActivityResource, CreateUserRS> pair = this.saveDefaultProjectService.saveDefaultProject(createUserRQFull, null);
        UserCreatedEvent userCreatedEvent = new UserCreatedEvent((UserActivityResource)pair.getKey(), ((UserActivityResource)pair.getKey()).getId(), login);
        this.userCreationBidRepository.deleteAllByEmail(email);
        this.messageBus.publishActivity(userCreatedEvent);
        return (CreateUserRS)pair.getValue();
    }

    @Override
    public OperationCompletionRS createRestorePasswordBid(RestorePasswordRQ rq, String baseUrl) {
        RestorePasswordBid bid;
        String email = EntityUtils.normalizeId((String)rq.getEmail());
        BusinessRule.expect((Object)UserUtils.isEmailValid((String)email), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{email});
        User user = (User)this.userRepository.findByEmail(email).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{email}));
        Optional bidOptional = this.restorePasswordBidRepository.findByEmail(rq.getEmail());
        if (bidOptional.isEmpty()) {
            BusinessRule.expect((Object)user.getUserType(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unable to change password for external user"});
            bid = RestorePasswordBidConverter.TO_BID.apply(rq);
            this.restorePasswordBidRepository.save((Object)bid);
        } else {
            bid = (RestorePasswordBid)bidOptional.get();
        }
        this.emailServiceFactory.getDefaultEmailService(true).sendRestorePasswordEmail("Password recovery", new String[]{email}, baseUrl + "#login?reset=" + bid.getUuid(), user.getLogin());
        return new OperationCompletionRS("Email has been sent");
    }

    @Override
    public OperationCompletionRS resetPassword(ResetPasswordRQ request) {
        RestorePasswordBid bid = (RestorePasswordBid)this.restorePasswordBidRepository.findById((Object)request.getUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.ACCESS_DENIED, new Object[]{"The password change link is no longer valid."}));
        String email = bid.getEmail();
        BusinessRule.expect((Object)UserUtils.isEmailValid((String)email), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{email});
        User byEmail = (User)this.userRepository.findByEmail(email).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[0]));
        BusinessRule.expect((Object)byEmail.getUserType(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unable to change password for external user"});
        byEmail.setPassword(this.passwordEncoder.encode((CharSequence)request.getPassword()));
        this.userRepository.save((Object)byEmail);
        this.restorePasswordBidRepository.deleteById((Object)request.getUuid());
        OperationCompletionRS rs = new OperationCompletionRS();
        rs.setResultMessage("Password has been changed");
        return rs;
    }

    @Override
    public YesNoRS isResetPasswordBidExist(String uuid) {
        Optional bid = this.restorePasswordBidRepository.findById((Object)uuid);
        return new YesNoRS(bid.isPresent());
    }

    private String normalizeAndValidateEmail(String email) {
        String normalizedEmail = EntityUtils.normalizeId((String)email.trim());
        BusinessRule.expect((Object)UserUtils.isEmailValid((String)normalizedEmail), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"email='{}'", (Object[])new Object[]{email})});
        Optional emailUser = this.userRepository.findByEmail(normalizedEmail);
        BusinessRule.expect((Object)emailUser.isPresent(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.USER_ALREADY_EXISTS, new Object[]{Suppliers.formattedSupplier((String)"email='{}'", (Object[])new Object[]{email})});
        return normalizedEmail;
    }

    private String normalizeAndValidateLogin(String login) {
        String normalizedLogin = EntityUtils.normalizeId((String)login.trim());
        Optional user = this.userRepository.findByLogin(normalizedLogin);
        BusinessRule.expect((Object)user.isPresent(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.USER_ALREADY_EXISTS, new Object[]{Suppliers.formattedSupplier((String)"login='{}'", (Object[])new Object[]{login})});
        BusinessRule.expect((Object)normalizedLogin, Predicates.SPECIAL_CHARS_ONLY.negate()).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Username '{}' consists only of special characters", (Object[])new Object[]{login})});
        return normalizedLogin;
    }
}

