/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.core.log.impl.SaveLogBinaryDataTask;
import com.epam.ta.reportportal.core.log.impl.SaveLogBinaryDataTaskAsync;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableAsync
public class ExecutorConfiguration {
    @Bean
    @Primary
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(5);
        scheduler.setThreadNamePrefix("default-task-sched");
        scheduler.setWaitForTasksToCompleteOnShutdown(true);
        return scheduler;
    }

    @Bean(name={"saveLogsTaskExecutor"})
    public TaskExecutor saveLogsTaskExecutor(@Value(value="${rp.environment.variable.executor.pool.save-logs.core}") Integer corePoolSize, @Value(value="${rp.environment.variable.executor.pool.save-logs.max}") Integer maxPoolSize, @Value(value="${rp.environment.variable.executor.pool.save-logs.queue}") Integer queueCapacity) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize.intValue());
        executor.setMaxPoolSize(maxPoolSize.intValue());
        executor.setQueueCapacity(queueCapacity.intValue());
        executor.setAllowCoreThreadTimeOut(true);
        executor.setThreadNamePrefix("logs-task-exec");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @Bean
    @Scope(value="prototype")
    public SaveLogBinaryDataTask saveLogBinaryDataTask() {
        return new SaveLogBinaryDataTask();
    }

    @Bean
    @Scope(value="prototype")
    public SaveLogBinaryDataTaskAsync saveLogBinaryDataTaskAsync() {
        return new SaveLogBinaryDataTaskAsync();
    }

    @Bean(name={"autoAnalyzeTaskExecutor"})
    public TaskExecutor autoAnalyzeTaskExecutor(@Value(value="${rp.environment.variable.executor.pool.auto-analyze.core}") Integer corePoolSize, @Value(value="${rp.environment.variable.executor.pool.auto-analyze.max}") Integer maxPoolSize, @Value(value="${rp.environment.variable.executor.pool.auto-analyze.queue}") Integer queueCapacity) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(corePoolSize.intValue());
        threadPoolTaskExecutor.setMaxPoolSize(maxPoolSize.intValue());
        threadPoolTaskExecutor.setQueueCapacity(queueCapacity.intValue());
        threadPoolTaskExecutor.setAllowCoreThreadTimeOut(true);
        threadPoolTaskExecutor.setThreadNamePrefix("auto-analyze-exec");
        return threadPoolTaskExecutor;
    }

    @Bean(name={"demoDataTaskExecutor"})
    public TaskExecutor demoDataTaskExecutor(@Value(value="${rp.environment.variable.executor.pool.demo-data.core}") Integer corePoolSize, @Value(value="${rp.environment.variable.executor.pool.demo-data.max}") Integer maxPoolSize, @Value(value="${rp.environment.variable.executor.pool.demo-data.queue}") Integer queueCapacity) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(corePoolSize.intValue());
        threadPoolTaskExecutor.setMaxPoolSize(maxPoolSize.intValue());
        threadPoolTaskExecutor.setQueueCapacity(queueCapacity.intValue());
        threadPoolTaskExecutor.setAllowCoreThreadTimeOut(true);
        threadPoolTaskExecutor.setAwaitTerminationSeconds(60);
        threadPoolTaskExecutor.setThreadNamePrefix("demo-data-exec");
        return threadPoolTaskExecutor;
    }

    @Bean(name={"healthCheckTableExecutor"})
    public TaskExecutor healthCheckTableExecutor(@Value(value="${rp.environment.variable.executor.pool.health-check-table.core}") Integer corePoolSize, @Value(value="${rp.environment.variable.executor.pool.health-check-table.max}") Integer maxPoolSize, @Value(value="${rp.environment.variable.executor.pool.health-check-table.queue}") Integer queueCapacity) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize.intValue());
        executor.setMaxPoolSize(maxPoolSize.intValue());
        executor.setQueueCapacity(queueCapacity.intValue());
        executor.setAllowCoreThreadTimeOut(true);
        executor.setThreadNamePrefix("hc-table-generate-task");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @EnableScheduling
    public static class SchedulingConfiguration {
    }
}

