/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.migration;

import com.epam.ta.reportportal.core.integration.migration.AbstractSecretMigrationService;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import java.util.Optional;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LdapSecretMigrationService
extends AbstractSecretMigrationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapSecretMigrationService.class);
    private static final String LDAP_INTEGRATION_TYPE_NAME = "ldap";
    private static final String LDAP_SECURE_PROPERTY = "managerPassword";
    @Value(value="${rp.auth.encryptor.password:reportportal}")
    private String salt;

    public LdapSecretMigrationService(IntegrationRepository integrationRepository, BasicTextEncryptor encryptor) {
        super(integrationRepository, encryptor);
    }

    @Override
    @Transactional
    public void migrate() {
        LOGGER.debug("Migration of LDAP secrets has been started");
        BasicTextEncryptor propertySaltEncryptor = new BasicTextEncryptor();
        propertySaltEncryptor.setPassword(this.salt);
        this.integrationRepository.findAllByTypeIn(new String[]{LDAP_INTEGRATION_TYPE_NAME}).forEach(it -> LdapSecretMigrationService.extractParams(it).ifPresent(params -> Optional.ofNullable(params.get(LDAP_SECURE_PROPERTY)).map(param -> (String)param).ifPresent(param -> params.put(LDAP_SECURE_PROPERTY, this.encryptor.encrypt(propertySaltEncryptor.decrypt(param))))));
        LOGGER.debug("Migration of LDAP secrets has been finished");
    }
}

