/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.retry;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.events.item.ItemRetryEvent;
import com.epam.ta.reportportal.core.item.impl.retry.RetriesHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class RetriesHandlerImpl
implements RetriesHandler {
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final ApplicationEventPublisher eventPublisher;

    public RetriesHandlerImpl(LaunchRepository launchRepository, TestItemRepository testItemRepository, ApplicationEventPublisher eventPublisher) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void handleRetries(Launch launch, TestItem newRetryParent, @Nullable String previousParent) {
        Optional.ofNullable(previousParent).flatMap(arg_0 -> ((TestItemRepository)this.testItemRepository).findByUuid(arg_0)).ifPresentOrElse(prev -> this.handleRetries(launch, (TestItem)prev, newRetryParent), () -> this.handleRetries(launch, newRetryParent));
        this.eventPublisher.publishEvent((Object)ItemRetryEvent.of(launch.getProjectId(), launch.getId(), newRetryParent.getItemId()));
    }

    private void handleRetries(Launch launch, TestItem retryParent, TestItem newRetryParent) {
        this.validateNewParent(retryParent, newRetryParent);
        this.testItemRepository.handleRetry(retryParent.getItemId(), newRetryParent.getItemId());
        this.updateLaunchRetriesState(launch);
    }

    private void validateNewParent(TestItem prevRetryParent, TestItem newRetryParent) {
        BusinessRule.expect((Object)newRetryParent, i -> !i.getUuid().equals(prevRetryParent.getUuid())).verify(ErrorType.RETRIES_HANDLER_ERROR, new Object[]{"Previous and new parent 'uuid' should not be equal"});
        BusinessRule.expect((Object)newRetryParent, i -> Objects.isNull(i.getRetryOf())).verify(ErrorType.RETRIES_HANDLER_ERROR, new Object[]{"Parent item should not be a retry"});
    }

    private void handleRetries(Launch launch, TestItem item) {
        this.testItemRepository.handleRetries(item.getItemId());
        this.updateLaunchRetriesState(launch);
    }

    private void updateLaunchRetriesState(Launch launch) {
        if (!launch.isHasRetries()) {
            launch.setHasRetries(this.launchRepository.hasRetries(launch.getId()));
        }
    }
}

