/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.util;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import java.time.LocalDateTime;
import java.util.function.Predicate;

public class LaunchValidator {
    private LaunchValidator() {
    }

    public static void validate(Launch launch, FinishExecutionRQ finishExecutionRQ) {
        BusinessRule.expect((Object)launch.getStatus(), (Predicate)Predicates.equalTo((Object)StatusEnum.IN_PROGRESS)).verify(ErrorType.FINISH_LAUNCH_NOT_ALLOWED, new Object[]{Suppliers.formattedSupplier((String)"Launch '{}' already finished with status '{}'", (Object[])new Object[]{launch.getId(), launch.getStatus()})});
        BusinessRule.expect((Object)finishExecutionRQ.getEndTime(), (Predicate)Preconditions.sameTimeOrLater((LocalDateTime)launch.getStartTime())).verify(ErrorType.FINISH_TIME_EARLIER_THAN_START_TIME, new Object[]{EntityUtils.TO_LOCAL_DATE_TIME.apply(finishExecutionRQ.getEndTime()), launch.getStartTime(), launch.getId()});
    }

    public static void validateRoles(Launch launch, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            if (!launch.isRerun() && projectDetails.getProjectRole().lowerThan(ProjectRole.PROJECT_MANAGER)) {
                BusinessRule.expect((Object)user.getUserId(), Predicate.isEqual(launch.getUserId())).verify(ErrorType.ACCESS_DENIED, new Object[]{"You are not launch owner."});
            }
        }
    }

    public static void validateProvidedStatus(Launch launch, StatusEnum providedStatus, StatusEnum fromStatisticsStatus) {
        BusinessRule.expect((Object)providedStatus, (Predicate)Predicates.not((Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.IN_PROGRESS, StatusEnum.SKIPPED}))).verify(ErrorType.INCORRECT_FINISH_STATUS, new Object[]{Suppliers.formattedSupplier((String)"Cannot finish launch '{}' with status '{}'", (Object[])new Object[]{launch.getId(), providedStatus})});
        if (StatusEnum.PASSED.equals((Object)providedStatus)) {
            BusinessRule.expect((Object)launch.getStatus(), (Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.IN_PROGRESS, StatusEnum.PASSED})).verify(ErrorType.INCORRECT_FINISH_STATUS, new Object[]{Suppliers.formattedSupplier((String)"Cannot finish launch '{}' with current status '{}' as 'PASSED'", (Object[])new Object[]{launch.getId(), launch.getStatus()})});
            BusinessRule.expect((Object)fromStatisticsStatus, (Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.IN_PROGRESS, StatusEnum.PASSED})).verify(ErrorType.INCORRECT_FINISH_STATUS, new Object[]{Suppliers.formattedSupplier((String)"Cannot finish launch '{}' with calculated automatically status '{}' as 'PASSED'", (Object[])new Object[]{launch.getId(), fromStatisticsStatus})});
        }
    }
}

