/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.LoadContentStrategy;
import com.epam.ta.reportportal.core.widget.content.loader.AbstractStatisticsContentLoader;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.dao.constant.WidgetContentRepositoryConstants;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.entity.widget.content.ChartStatisticsContent;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ChartInvestigatedContentLoader
extends AbstractStatisticsContentLoader
implements LoadContentStrategy {
    @Autowired
    private WidgetContentRepository widgetContentRepository;

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        Optional<AbstractStatisticsContentLoader.Period> period;
        this.validateFilterSortMapping(filterSortMapping);
        Filter filter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
        Sort sort = WidgetFilterUtil.GROUP_SORTS.apply(filterSortMapping.values());
        String timeLineOption = WidgetOptionUtil.getValueByKey("timeline", widgetOptions);
        if (StringUtils.isNotBlank((CharSequence)timeLineOption) && (period = AbstractStatisticsContentLoader.Period.findByName(timeLineOption)).isPresent()) {
            Map<String, ChartStatisticsContent> statistics = this.groupByDate(this.widgetContentRepository.timelineInvestigatedStatistics(filter, sort, limit), period.get());
            return MapUtils.isEmpty(statistics) ? Collections.emptyMap() : this.calculateInvestigatedPercentage(statistics);
        }
        List content = this.widgetContentRepository.investigatedStatistics(filter, sort, limit);
        return CollectionUtils.isEmpty((Collection)content) ? Collections.emptyMap() : Collections.singletonMap("result", content);
    }

    private Map<String, ?> calculateInvestigatedPercentage(Map<String, ChartStatisticsContent> investigatedStatistics) {
        investigatedStatistics.values().forEach(c -> {
            Map values = c.getValues();
            BigDecimal divisor = BigDecimal.valueOf(Double.parseDouble((String)values.get("investigated")));
            if (0 != divisor.intValue()) {
                values.put("toInvestigate", String.valueOf(BigDecimal.valueOf(WidgetContentRepositoryConstants.PERCENTAGE_MULTIPLIER * Double.parseDouble((String)values.get("toInvestigate"))).divide(divisor, 2, RoundingMode.FLOOR).doubleValue()));
                values.put("investigated", String.valueOf(WidgetContentRepositoryConstants.PERCENTAGE_MULTIPLIER - Double.parseDouble((String)values.get("toInvestigate"))));
            } else {
                values.put("investigated", "0");
                values.put("toInvestigate", "0");
            }
        });
        return Collections.singletonMap("result", investigatedStatistics);
    }

    private void validateFilterSortMapping(Map<Filter, Sort> filterSortMapping) {
        BusinessRule.expect((Object)MapUtils.isNotEmpty(filterSortMapping), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Filter-Sort mapping should not be empty"});
    }
}

