/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.util.healthcheck;

import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.core.widget.content.loader.util.healthcheck.AbstractHealthCheckTableContentResolver;
import com.epam.ta.reportportal.core.widget.content.loader.util.healthcheck.util.HealthCheckTableGenerator;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetState;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.epam.ta.reportportal.entity.widget.content.healthcheck.HealthCheckTableInitParams;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="healthCheckTableCreatedContentResolver")
public class HealthCheckTableCreatedContentResolver
extends AbstractHealthCheckTableContentResolver {
    public static final String CUSTOM_COLUMN = "customColumn";
    private static final String VIEW_PREFIX = "hct";
    private static final String NAME_SEPARATOR = "_";
    protected final TaskExecutor healthCheckTableExecutor;
    protected final HealthCheckTableGenerator healthCheckTableGenerator;
    private final Map<WidgetType, BuildFilterStrategy> buildFilterStrategyMapping;
    private final WidgetRepository widgetRepository;

    public HealthCheckTableCreatedContentResolver(@Qualifier(value="healthCheckTableExecutor") TaskExecutor healthCheckTableExecutor, HealthCheckTableGenerator healthCheckTableGenerator, @Qualifier(value="buildFilterStrategy") Map<WidgetType, BuildFilterStrategy> buildFilterStrategyMapping, WidgetRepository widgetRepository) {
        this.healthCheckTableExecutor = healthCheckTableExecutor;
        this.healthCheckTableGenerator = healthCheckTableGenerator;
        this.buildFilterStrategyMapping = buildFilterStrategyMapping;
        this.widgetRepository = widgetRepository;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Map<String, Object> getContent(Widget widget, List<String> attributeKeys, List<String> attributeValues) {
        WidgetType widgetType = (WidgetType)WidgetType.findByName((String)widget.getWidgetType()).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Unsupported widget type '{}'", (Object[])new Object[]{widget.getWidgetType()})}));
        Map<Filter, Sort> filterSortMapping = this.buildFilterStrategyMapping.get(widgetType).buildFilter(widget);
        Filter launchesFilter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
        Sort launchesSort = WidgetFilterUtil.GROUP_SORTS.apply(filterSortMapping.values());
        this.widgetRepository.save((Object)new WidgetBuilder(widget).addOption("state", WidgetState.RENDERING.getValue()).get());
        this.generateContent(widget, attributeKeys, launchesFilter, launchesSort);
        return Collections.emptyMap();
    }

    protected void generateContent(Widget widget, List<String> attributeKeys, Filter launchesFilter, Sort launchesSort) {
        CompletableFuture.runAsync(() -> this.healthCheckTableGenerator.generate(false, this.getInitParams(widget, attributeKeys), widget, launchesFilter, launchesSort), (Executor)this.healthCheckTableExecutor);
    }

    protected HealthCheckTableInitParams getInitParams(Widget widget, List<String> attributeKeys) {
        String viewName = this.generateViewName(widget);
        return Optional.ofNullable(WidgetOptionUtil.getValueByKey(CUSTOM_COLUMN, widget.getWidgetOptions())).map(custom -> HealthCheckTableInitParams.of((String)viewName, (List)attributeKeys, (String)custom)).orElseGet(() -> HealthCheckTableInitParams.of((String)viewName, (List)attributeKeys));
    }

    private String generateViewName(Widget widget) {
        return String.join((CharSequence)NAME_SEPARATOR, VIEW_PREFIX, String.valueOf(widget.getProject().getId()), String.valueOf(widget.getId()));
    }
}

