/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.util.healthcheck;

import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.widget.content.loader.util.healthcheck.HealthCheckTableContentResolver;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetState;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckTableResolverStrategy {
    private static final String REFRESH = "refresh";
    private final Map<WidgetState, HealthCheckTableContentResolver> healthCheckTableContentResolverMapping;
    private final Map<WidgetState, HealthCheckTableContentResolver> healthCheckTableRefreshResolverMapping;

    @Autowired
    public HealthCheckTableResolverStrategy(@Qualifier(value="healthCheckTableContentResolverMapping") Map<WidgetState, HealthCheckTableContentResolver> healthCheckTableContentResolverMapping, @Qualifier(value="healthCheckTableContentRefreshMapping") Map<WidgetState, HealthCheckTableContentResolver> healthCheckTableRefreshResolverMapping) {
        this.healthCheckTableContentResolverMapping = healthCheckTableContentResolverMapping;
        this.healthCheckTableRefreshResolverMapping = healthCheckTableRefreshResolverMapping;
    }

    public Map<String, Object> resolveContent(Widget widget, String[] attributes, Map<String, String> params) {
        WidgetState widgetState = (WidgetState)Optional.ofNullable(WidgetOptionUtil.getValueByKey("state", widget.getWidgetOptions())).flatMap(WidgetState::findByName).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Widget state not provided"}));
        if (BooleanUtils.toBoolean((String)params.get(REFRESH))) {
            HealthCheckTableContentResolver resolver = Optional.ofNullable(this.healthCheckTableRefreshResolverMapping.get(widgetState)).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{Suppliers.formattedSupplier((String)"Widget should be in [{}] states to be refreshed", (Object[])new Object[]{this.healthCheckTableRefreshResolverMapping.keySet().stream().map(WidgetState::getValue).collect(Collectors.joining(","))}).get()}));
            return resolver.loadContent(widget, attributes, params);
        }
        return this.healthCheckTableContentResolverMapping.get(widgetState).loadContent(widget, attributes, params);
    }
}

