/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.dao.UserCreationBidRepository;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CleanExpiredCreationBidsJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanExpiredCreationBidsJob.class);
    @Autowired
    private UserCreationBidRepository repository;

    @Transactional
    public void execute(JobExecutionContext context) throws JobExecutionException {
        int deletedCount = this.repository.expireBidsOlderThan(Date.from(LocalDateTime.now().minusDays(1L).toInstant(ZoneOffset.UTC)));
        LOGGER.info("Cleaning expired user creation bids finished. Deleted {} bids", (Object)deletedCount);
    }
}

