/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ReportingQueueService {
    private static final String UUID_REGEX = "[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}";
    private int queueAmount;

    public int getQueueAmount() {
        return this.queueAmount;
    }

    @Value(value="${rp.amqp.queues}")
    public void setQueueAmount(int queueAmount) {
        this.queueAmount = queueAmount;
    }

    public String getReportingQueueKey(String launchUuid) {
        int value = launchUuid.matches(UUID_REGEX) ? UUID.fromString(launchUuid).hashCode() : launchUuid.hashCode();
        return String.valueOf((value &= Integer.MAX_VALUE) % this.queueAmount);
    }
}

