/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.dashboard.CreateDashboardHandler;
import com.epam.ta.reportportal.core.dashboard.DeleteDashboardHandler;
import com.epam.ta.reportportal.core.dashboard.GetDashboardHandler;
import com.epam.ta.reportportal.core.dashboard.UpdateDashboardHandler;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.converter.converters.DashboardConverter;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.dashboard.AddWidgetRq;
import com.epam.ta.reportportal.ws.model.dashboard.CreateDashboardRQ;
import com.epam.ta.reportportal.ws.model.dashboard.DashboardResource;
import com.epam.ta.reportportal.ws.model.dashboard.UpdateDashboardRQ;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
@RequestMapping(value={"/v1/{projectName}/dashboard"})
public class DashboardController {
    private final CreateDashboardHandler createDashboardHandler;
    private final UpdateDashboardHandler updateDashboardHandler;
    private final GetDashboardHandler getDashboardHandler;
    private final GetShareableEntityHandler<Dashboard> getShareableEntityHandler;
    private final DeleteDashboardHandler deleteDashboardHandler;

    @Autowired
    public DashboardController(CreateDashboardHandler createDashboardHandler, UpdateDashboardHandler updateDashboardHandler, GetDashboardHandler getDashboardHandler, GetShareableEntityHandler<Dashboard> getShareableEntityHandler, DeleteDashboardHandler deleteDashboardHandler) {
        this.createDashboardHandler = createDashboardHandler;
        this.updateDashboardHandler = updateDashboardHandler;
        this.getDashboardHandler = getDashboardHandler;
        this.getShareableEntityHandler = getShareableEntityHandler;
        this.deleteDashboardHandler = deleteDashboardHandler;
    }

    @Transactional
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Create dashboard for specified project")
    public EntryCreatedRS createDashboard(@PathVariable String projectName, @RequestBody @Validated CreateDashboardRQ createRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createDashboardHandler.createDashboard(ProjectExtractor.extractProjectDetails(user, projectName), createRQ, user);
    }

    @Transactional(readOnly=true)
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all permitted dashboard resources for specified project")
    public Iterable<DashboardResource> getAllDashboards(@PathVariable String projectName, @SortFor(value=Dashboard.class) Pageable pageable, @FilterFor(value=Dashboard.class) Filter filter, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getDashboardHandler.getPermitted(ProjectExtractor.extractProjectDetails(user, projectName), pageable, filter, user);
    }

    @Transactional
    @PutMapping(value={"/{dashboardId}/add"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Add widget to specified dashboard")
    public OperationCompletionRS addWidget(@PathVariable String projectName, @PathVariable Long dashboardId, @RequestBody @Validated AddWidgetRq addWidgetRq, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateDashboardHandler.addWidget(dashboardId, ProjectExtractor.extractProjectDetails(user, projectName), addWidgetRq, user);
    }

    @Transactional
    @DeleteMapping(value={"/{dashboardId}/{widgetId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Remove widget from specified dashboard")
    public OperationCompletionRS removeWidget(@PathVariable String projectName, @PathVariable Long dashboardId, @PathVariable Long widgetId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateDashboardHandler.removeWidget(widgetId, dashboardId, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional
    @PutMapping(value={"/{dashboardId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update specified dashboard for specified project")
    public OperationCompletionRS updateDashboard(@PathVariable String projectName, @PathVariable Long dashboardId, @RequestBody @Validated UpdateDashboardRQ updateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateDashboardHandler.updateDashboard(ProjectExtractor.extractProjectDetails(user, projectName), updateRQ, dashboardId, user);
    }

    @Transactional
    @DeleteMapping(value={"/{dashboardId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete specified dashboard by ID for specified project")
    public OperationCompletionRS deleteDashboard(@PathVariable String projectName, @PathVariable Long dashboardId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteDashboardHandler.deleteDashboard(dashboardId, ProjectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional
    @GetMapping(value={"/{dashboardId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get specified dashboard by ID for specified project")
    public DashboardResource getDashboard(@PathVariable String projectName, @PathVariable Long dashboardId, @AuthenticationPrincipal ReportPortalUser user) {
        Dashboard dashboard = this.getShareableEntityHandler.getPermitted(dashboardId, ProjectExtractor.extractProjectDetails(user, projectName));
        return DashboardConverter.TO_RESOURCE.apply(dashboard);
    }

    @GetMapping(value={"/shared"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get names of shared dashboards from specified project")
    public Iterable<SharedEntity> getSharedDashboardsNames(@PathVariable String projectName, @SortFor(value=Dashboard.class) Pageable pageable, @FilterFor(value=Dashboard.class) Filter filter, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getDashboardHandler.getSharedDashboardsNames(ProjectExtractor.extractProjectDetails(user, projectName), pageable, filter, user);
    }
}

