/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.acl;

import com.epam.ta.reportportal.auth.acl.ReportPortalAclService;
import com.epam.ta.reportportal.dao.ShareableEntityRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.model.Permission;
import org.springframework.stereotype.Service;

@Service
public class ShareableObjectsHandler {
    @Autowired
    private ReportPortalAclService aclService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ShareableEntityRepository shareableEntityRepository;

    public void initAcl(Object object, String owner, Long projectId, boolean isShared) {
        this.aclService.createAcl(object);
        this.aclService.addPermissions(object, owner, BasePermission.ADMINISTRATION);
        if (isShared) {
            this.userRepository.findUsernamesWithProjectRolesByProjectId(projectId).entrySet().stream().filter(entry -> !((String)entry.getKey()).equalsIgnoreCase(owner)).forEach(entry -> {
                if (((ProjectRole)entry.getValue()).sameOrHigherThan(ProjectRole.PROJECT_MANAGER)) {
                    this.aclService.addPermissions(object, (String)entry.getKey(), BasePermission.ADMINISTRATION);
                } else {
                    this.aclService.addPermissions(object, (String)entry.getKey(), BasePermission.READ);
                }
            });
        }
    }

    public void updateAcl(Object object, Long projectId, boolean isShared) {
        if (isShared) {
            this.userRepository.findUsernamesWithProjectRolesByProjectId(projectId).forEach((username, projectRole) -> {
                if (projectRole.sameOrHigherThan(ProjectRole.PROJECT_MANAGER)) {
                    this.aclService.addPermissions(object, (String)username, BasePermission.ADMINISTRATION);
                } else {
                    this.aclService.addPermissions(object, (String)username, BasePermission.READ);
                }
            });
        } else {
            this.userRepository.findNamesByProject(projectId).forEach(login -> this.aclService.removePermissions(object, (String)login));
        }
    }

    public void preventSharedObjects(Long projectId, String userName) {
        List sharedEntities = this.shareableEntityRepository.findAllByProjectIdAndShared(projectId, true);
        sharedEntities.forEach(entity -> this.aclService.removePermissions(entity, userName));
    }

    public void permitSharedObjects(Long projectId, String userName, Permission permission) {
        List shareableEntities = this.shareableEntityRepository.findAllByProjectIdAndShared(projectId, true);
        shareableEntities.forEach(entity -> this.aclService.addPermissions(entity, userName, permission));
    }

    public void deleteAclForObject(Object object) {
        this.aclService.deleteAcl(object);
    }
}

