/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler;

import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.events.widget.GenerateComponentHealthCheckTableEvent;
import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.core.widget.content.loader.util.healthcheck.util.HealthCheckTableGenerator;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.epam.ta.reportportal.entity.widget.content.healthcheck.HealthCheckTableInitParams;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionalEventListener;

@Service
public class ComponentHealthCheckTableEventHandler {
    public static final String CUSTOM_COLUMN = "customColumn";
    private static final String VIEW_PREFIX = "hct";
    private static final String NAME_SEPARATOR = "_";
    private final WidgetRepository widgetRepository;
    private final Map<WidgetType, BuildFilterStrategy> buildFilterStrategyMapping;
    private final TaskExecutor healthCheckTableExecutor;
    private final HealthCheckTableGenerator healthCheckTableGenerator;

    @Autowired
    public ComponentHealthCheckTableEventHandler(WidgetRepository widgetRepository, @Qualifier(value="buildFilterStrategy") Map<WidgetType, BuildFilterStrategy> buildFilterStrategyMapping, @Qualifier(value="healthCheckTableExecutor") TaskExecutor healthCheckTableExecutor, HealthCheckTableGenerator healthCheckTableGenerator) {
        this.widgetRepository = widgetRepository;
        this.buildFilterStrategyMapping = buildFilterStrategyMapping;
        this.healthCheckTableExecutor = healthCheckTableExecutor;
        this.healthCheckTableGenerator = healthCheckTableGenerator;
    }

    @Async
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @TransactionalEventListener
    public void onApplicationEvent(GenerateComponentHealthCheckTableEvent event) {
        this.widgetRepository.findById((Object)event.getWidgetId()).ifPresent(widget -> {
            BusinessRule.expect((Object)widget.getWidgetType(), type -> WidgetType.COMPONENT_HEALTH_CHECK_TABLE.getType().equals(type)).verify(ErrorType.UNABLE_TO_CREATE_WIDGET, new Object[]{Suppliers.formattedSupplier((String)"Wrong widget type '{}'. Expected '{}'", (Object[])new Object[]{widget.getWidgetType(), WidgetType.COMPONENT_HEALTH_CHECK_TABLE.getType()}).get()});
            Map<Filter, Sort> filterSortMapping = this.buildFilterStrategyMapping.get(WidgetType.COMPONENT_HEALTH_CHECK_TABLE).buildFilter((Widget)widget);
            Filter launchesFilter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
            Sort launchesSort = WidgetFilterUtil.GROUP_SORTS.apply(filterSortMapping.values());
            this.healthCheckTableExecutor.execute(() -> this.healthCheckTableGenerator.generate(event.isRefresh(), this.getInitParams((Widget)widget, event.getAttributeKeys()), (Widget)widget, launchesFilter, launchesSort));
        });
    }

    private HealthCheckTableInitParams getInitParams(Widget widget, List<String> attributeKeys) {
        String viewName = this.generateViewName(widget);
        return Optional.ofNullable(WidgetOptionUtil.getValueByKey(CUSTOM_COLUMN, widget.getWidgetOptions())).map(custom -> HealthCheckTableInitParams.of((String)viewName, (List)attributeKeys, (String)custom)).orElseGet(() -> HealthCheckTableInitParams.of((String)viewName, (List)attributeKeys));
    }

    private String generateViewName(Widget widget) {
        return String.join((CharSequence)NAME_SEPARATOR, VIEW_PREFIX, String.valueOf(widget.getProject().getId()), String.valueOf(widget.getId()));
    }
}

