/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.imprt.impl.AbstractImportStrategy;
import com.epam.ta.reportportal.core.imprt.impl.ParseResults;
import com.epam.ta.reportportal.core.imprt.impl.junit.XunitParseJob;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZipImportStrategy
extends AbstractImportStrategy {
    private static final Predicate<ZipEntry> isFile = zipEntry -> !zipEntry.isDirectory();
    private static final Predicate<ZipEntry> isXml = zipEntry -> zipEntry.getName().endsWith("xml");
    @Autowired
    private Provider<XunitParseJob> xmlParseJobProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String importLaunch(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, File file, String baseUrl) {
        try {
            String string = this.processZipFile(file, projectDetails, user, baseUrl);
            return string;
        }
        finally {
            try {
                Optional.ofNullable(file).ifPresent(File::delete);
            }
            catch (Exception e) {
                LOGGER.error("File '{}' was not successfully deleted.", (Object)file.getName(), (Object)e);
            }
        }
    }

    private String processZipFile(File zip, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, String baseUrl) {
        String string;
        String savedLaunchId = null;
        ZipFile zipFile = new ZipFile(zip);
        try {
            String launchId;
            savedLaunchId = launchId = this.startLaunch(projectDetails, user, zip.getName().substring(0, zip.getName().indexOf(".zip")));
            CompletableFuture[] futures = (CompletableFuture[])zipFile.stream().filter(isFile.and(isXml)).map(zipEntry -> {
                XunitParseJob job = ((XunitParseJob)this.xmlParseJobProvider.get()).withParameters(projectDetails, launchId, user, this.getEntryStream(zipFile, (ZipEntry)zipEntry));
                return CompletableFuture.supplyAsync(job::call, service);
            }).toArray(CompletableFuture[]::new);
            ParseResults parseResults = this.processResults(futures);
            this.finishLaunch(launchId, projectDetails, user, parseResults, baseUrl);
            string = launchId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.updateBrokenLaunch(savedLaunchId);
                throw new ReportPortalException(ErrorType.IMPORT_FILE_ERROR, new Object[]{this.cleanMessage(e)});
            }
        }
        zipFile.close();
        return string;
    }

    private InputStream getEntryStream(ZipFile file, ZipEntry zipEntry) {
        try {
            return file.getInputStream(zipEntry);
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.IMPORT_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }
}

