/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.history.provider.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.TestItemService;
import com.epam.ta.reportportal.core.item.impl.LaunchAccessValidator;
import com.epam.ta.reportportal.core.item.impl.history.param.HistoryRequestParams;
import com.epam.ta.reportportal.core.item.impl.history.provider.HistoryProvider;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.history.TestItemHistory;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class TestItemBaselineHistoryProvider
implements HistoryProvider {
    private final TestItemService testItemService;
    private final LaunchAccessValidator launchAccessValidator;
    private final TestItemRepository testItemRepository;

    @Autowired
    public TestItemBaselineHistoryProvider(TestItemService testItemService, LaunchAccessValidator launchAccessValidator, TestItemRepository testItemRepository) {
        this.testItemService = testItemService;
        this.launchAccessValidator = launchAccessValidator;
        this.testItemRepository = testItemRepository;
    }

    @Override
    public Page<TestItemHistory> provide(Queryable filter, Pageable pageable, HistoryRequestParams historyRequestParams, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, boolean usingHash) {
        return historyRequestParams.getParentId().map(itemId -> this.loadHistory(filter, pageable, (Long)itemId, historyRequestParams, projectDetails, user, usingHash)).orElseGet(() -> historyRequestParams.getItemId().map(itemId -> this.loadHistory(filter, pageable, (Long)itemId, historyRequestParams, projectDetails, user, usingHash)).orElseGet(() -> Page.empty((Pageable)pageable)));
    }

    private Page<TestItemHistory> loadHistory(Queryable filter, Pageable pageable, Long itemId, HistoryRequestParams historyRequestParams, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, boolean usingHash) {
        TestItem testItem = (TestItem)this.testItemRepository.findById((Object)itemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId}));
        Launch launch = this.testItemService.getEffectiveLaunch(testItem);
        this.launchAccessValidator.validate(launch.getId(), projectDetails, user);
        return historyRequestParams.getHistoryType().filter(HistoryRequestParams.HistoryTypeEnum.LINE::equals).map(type -> this.testItemRepository.loadItemsHistoryPage(filter, pageable, projectDetails.getProjectId(), launch.getName(), historyRequestParams.getHistoryDepth(), usingHash)).orElseGet(() -> this.testItemRepository.loadItemsHistoryPage(filter, pageable, projectDetails.getProjectId(), historyRequestParams.getHistoryDepth(), usingHash));
    }
}

