/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.impl.LaunchPreparerService;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.LaunchMergeFactory;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.MergeStrategyType;
import com.epam.ta.reportportal.core.launch.MergeLaunchHandler;
import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.analyzer.IndexLaunch;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.launch.MergeLaunchesRQ;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MergeLaunchHandlerImpl
implements MergeLaunchHandler {
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final ProjectRepository projectRepository;
    private final LaunchMergeFactory launchMergeFactory;
    private final LaunchConverter launchConverter;
    private final LaunchPreparerService launchPreparerService;
    private final LogIndexer logIndexer;

    @Autowired
    public MergeLaunchHandlerImpl(LaunchRepository launchRepository, TestItemRepository testItemRepository, ProjectRepository projectRepository, LaunchMergeFactory launchMergeFactory, LaunchConverter launchConverter, LaunchPreparerService launchPreparerService, LogIndexer logIndexer) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.projectRepository = projectRepository;
        this.launchMergeFactory = launchMergeFactory;
        this.launchConverter = launchConverter;
        this.launchPreparerService = launchPreparerService;
        this.logIndexer = logIndexer;
    }

    @Override
    public LaunchResource mergeLaunches(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, MergeLaunchesRQ rq) {
        Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectName()}));
        Set launchesIds = rq.getLaunches();
        BusinessRule.expect((Object)CollectionUtils.isNotEmpty((Collection)launchesIds), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"At least one launch id should be  specified for merging"});
        BusinessRule.expect((Object)(launchesIds.size() > 0 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"At least 1 launch id should be provided for merging"});
        List launchesList = this.launchRepository.findAllById((Iterable)launchesIds);
        BusinessRule.expect((Object)launchesIds.size(), (Predicate)Predicates.equalTo((Object)launchesList.size())).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Not all launches with provided ids were found"});
        this.validateMergingLaunches(launchesList, user, projectDetails);
        MergeStrategyType type = MergeStrategyType.fromValue(rq.getMergeStrategyType());
        BusinessRule.expect((Object)((Object)type), (Predicate)Predicates.notNull()).verify(ErrorType.UNSUPPORTED_MERGE_STRATEGY_TYPE, new Object[]{type});
        Launch newLaunch = this.launchMergeFactory.getLaunchMergeStrategy(type).mergeLaunches(projectDetails, user, rq, launchesList);
        newLaunch.setStatus(StatisticsHelper.getStatusFromStatistics(newLaunch.getStatistics()));
        this.launchRepository.deleteAll((Iterable)launchesList);
        List newItems = this.testItemRepository.findTestItemsByLaunchId(newLaunch.getId());
        this.launchPreparerService.prepare(newLaunch, newItems, AnalyzerUtils.getAnalyzerConfig(project)).ifPresent(it -> this.logIndexer.indexPreparedLogs(project.getId(), (IndexLaunch)it));
        return this.launchConverter.TO_RESOURCE.apply(newLaunch);
    }

    private void validateMergingLaunches(List<Launch> launches, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        boolean isUserValidate = !user.getUserRole().equals((Object)UserRole.ADMINISTRATOR) && !projectDetails.getProjectRole().sameOrHigherThan(ProjectRole.PROJECT_MANAGER);
        launches.forEach(launch -> {
            BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launch});
            BusinessRule.expect((Object)launch.getStatus(), (Predicate)Predicates.not((Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.IN_PROGRESS}))).verify(ErrorType.LAUNCH_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Cannot merge launch '{}' with status '{}'", (Object[])new Object[]{launch.getId(), launch.getStatus()})});
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Impossible to merge launches from different projects."});
            if (isUserValidate) {
                BusinessRule.expect((Object)launch.getUserId(), (Predicate)Predicates.equalTo((Object)user.getUserId())).verify(ErrorType.ACCESS_DENIED, new Object[]{"You are not an owner of launches or have less than PROJECT_MANAGER project role."});
            }
        });
    }
}

