/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.util.healthcheck;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.loader.util.healthcheck.HealthCheckTableContentResolver;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractHealthCheckTableContentResolver
implements HealthCheckTableContentResolver {
    public static final Integer MAX_LEVEL_NUMBER = 10;

    protected abstract Map<String, Object> getContent(Widget var1, List<String> var2, List<String> var3);

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Map<String, Object> loadContent(Widget widget, String[] attributes, Map<String, String> params) {
        WidgetOptions widgetOptions = widget.getWidgetOptions();
        this.validateWidgetOptions(widgetOptions);
        List<String> attributeKeys = WidgetOptionUtil.getListByKey("attributeKeys", widgetOptions);
        this.validateAttributeKeys(attributeKeys);
        List attributeValues = Optional.ofNullable(attributes).map(Arrays::asList).orElseGet(Collections::emptyList);
        this.validateAttributeValues(attributeValues);
        return this.getContent(widget, attributeKeys, attributeValues);
    }

    private void validateAttributeKeys(List<String> attributeKeys) {
        BusinessRule.expect(attributeKeys, CollectionUtils::isNotEmpty).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"No keys were specified"});
        BusinessRule.expect(attributeKeys, cf -> cf.size() <= MAX_LEVEL_NUMBER).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Keys number is incorrect. Maximum keys count = " + MAX_LEVEL_NUMBER});
        attributeKeys.forEach(cf -> BusinessRule.expect((Object)cf, StringUtils::isNotBlank).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Current level key should be not null"}));
    }

    private void validateWidgetOptions(WidgetOptions widgetOptions) {
        BusinessRule.expect((Object)widgetOptions, Objects::nonNull).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Widgets options not provided"});
        WidgetOptionUtil.getIntegerByKey("minPassingRate", widgetOptions).map(value -> {
            BusinessRule.expect((Object)value, v -> v >= 0 && v <= 100).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Minimum passing rate value should be greater or equal to 0 and less or equal to 100"});
            return value;
        }).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Minimum passing rate option was not specified"}));
    }

    private void validateAttributeValues(List<String> attributeValues) {
        attributeValues.forEach(value -> BusinessRule.expect((Object)value, Objects::nonNull).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Attribute value should be not null"}));
    }
}

