/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.util.healthcheck;

import com.epam.ta.reportportal.core.events.widget.GenerateComponentHealthCheckTableEvent;
import com.epam.ta.reportportal.core.widget.content.loader.util.healthcheck.AbstractHealthCheckTableContentResolver;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetState;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service(value="healthCheckTableCreatedContentResolver")
public class HealthCheckTableCreatedContentResolver
extends AbstractHealthCheckTableContentResolver {
    private final WidgetRepository widgetRepository;
    protected ApplicationEventPublisher eventPublisher;

    public HealthCheckTableCreatedContentResolver(WidgetRepository widgetRepository, @Qualifier(value="webApplicationContext") ApplicationEventPublisher eventPublisher) {
        this.widgetRepository = widgetRepository;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public Map<String, Object> getContent(Widget widget, List<String> attributeKeys, List<String> attributeValues) {
        this.widgetRepository.save((Object)new WidgetBuilder(widget).addOption("state", WidgetState.RENDERING.getValue()).get());
        this.generateContent(widget, attributeKeys);
        return Collections.emptyMap();
    }

    protected void generateContent(Widget widget, List<String> attributeKeys) {
        this.eventPublisher.publishEvent((Object)new GenerateComponentHealthCheckTableEvent(widget.getId(), false, attributeKeys));
    }
}

