/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job.service.impl;

import com.epam.ta.reportportal.binary.DataStoreService;
import com.epam.ta.reportportal.dao.AttachmentRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.attachment.Attachment;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.job.PageUtil;
import com.epam.ta.reportportal.job.service.AttachmentCleanerService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AttachmentCleanerServiceImpl
implements AttachmentCleanerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentCleanerServiceImpl.class);
    private final Integer itemPageSize;
    private final AttachmentRepository attachmentRepository;
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final DataStoreService dataStoreService;

    @Autowired
    public AttachmentCleanerServiceImpl(@Value(value="${rp.environment.variable.clean.items.size}") Integer itemPageSize, AttachmentRepository attachmentRepository, LaunchRepository launchRepository, TestItemRepository testItemRepository, @Qualifier(value="attachmentDataStoreService") DataStoreService dataStoreService) {
        this.itemPageSize = itemPageSize;
        this.attachmentRepository = attachmentRepository;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.dataStoreService = dataStoreService;
    }

    @Override
    public void removeOutdatedItemsAttachments(Collection<Long> itemIds, LocalDateTime before, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        List attachments = this.attachmentRepository.findByItemIdsAndLogTimeBefore(itemIds, before);
        this.removeAttachments(attachments, attachmentsCount, thumbnailsCount);
    }

    @Override
    public void removeOutdatedLaunchesAttachments(Collection<Long> launchIds, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        List attachments = this.attachmentRepository.findAllByLaunchIdIn(launchIds);
        this.removeAttachments(attachments, attachmentsCount, thumbnailsCount);
    }

    @Override
    public void removeOutdatedLaunchesAttachments(Collection<Long> launchIds, LocalDateTime before, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        List launchAttachments = this.attachmentRepository.findByLaunchIdsAndLogTimeBefore(launchIds, before);
        this.removeAttachments(launchAttachments, attachmentsCount, thumbnailsCount);
    }

    @Override
    @Transactional
    public void removeProjectAttachments(Project project, LocalDateTime before, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        try (Stream launchIds = this.launchRepository.streamIdsByStartTimeBefore(project.getId(), before);){
            launchIds.forEach(id -> {
                PageUtil.iterateOverContent(this.itemPageSize, pageable -> this.testItemRepository.findTestItemIdsByLaunchId(id, pageable), ids -> {
                    List attachments = this.attachmentRepository.findByItemIdsAndLogTimeBefore((Collection)ids, before);
                    this.removeAttachments(attachments, attachmentsCount, thumbnailsCount);
                });
                this.removeOutdatedLaunchesAttachments(Collections.singletonList(id), before, attachmentsCount, thumbnailsCount);
            });
        }
        catch (Exception e) {
            LOGGER.error("Error during cleaning project attachments", (Throwable)e);
        }
    }

    private void removeAttachments(Collection<Attachment> attachments, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        ArrayList attachmentIds = new ArrayList();
        attachments.forEach(it -> {
            try {
                Optional.ofNullable(it).ifPresent(attachment -> {
                    Optional.ofNullable(attachment.getFileId()).ifPresent(fileId -> {
                        this.dataStoreService.delete(fileId);
                        attachmentsCount.addAndGet(1L);
                    });
                    Optional.ofNullable(attachment.getThumbnailId()).ifPresent(thumbnailId -> {
                        this.dataStoreService.delete(thumbnailId);
                        thumbnailsCount.addAndGet(1L);
                    });
                    attachmentIds.add(attachment.getId());
                });
            }
            catch (Exception ex) {
                LOGGER.debug("Error has occurred during the attachments removing", (Throwable)ex);
            }
        });
        if (CollectionUtils.isNotEmpty(attachmentIds)) {
            this.attachmentRepository.deleteAllByIds(attachmentIds);
        }
    }
}

