/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job.service.impl;

import com.epam.ta.reportportal.dao.ActivityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.job.service.AttachmentCleanerService;
import com.epam.ta.reportportal.job.service.LaunchCleanerService;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LaunchCleanerServiceImpl
implements LaunchCleanerService {
    private final LaunchRepository launchRepository;
    private final ActivityRepository activityRepository;
    private final AttachmentCleanerService attachmentCleanerService;

    @Autowired
    public LaunchCleanerServiceImpl(LaunchRepository launchRepository, ActivityRepository activityRepository, AttachmentCleanerService attachmentCleanerService) {
        this.launchRepository = launchRepository;
        this.activityRepository = activityRepository;
        this.attachmentCleanerService = attachmentCleanerService;
    }

    @Override
    @Transactional
    public void cleanOutdatedLaunches(Project project, Duration period, AtomicLong launchesRemoved, AtomicLong attachmentsRemoved, AtomicLong thumbnailsRemoved) {
        this.activityRepository.deleteModifiedLaterAgo(project.getId(), period);
        List launchIds = this.launchRepository.findIdsByProjectIdAndStartTimeBefore(project.getId(), LocalDateTime.now(ZoneOffset.UTC).minus(period));
        this.attachmentCleanerService.removeOutdatedLaunchesAttachments(launchIds, attachmentsRemoved, thumbnailsRemoved);
        this.launchRepository.deleteAllByIdIn((Collection)launchIds);
        launchesRemoved.addAndGet(launchIds.size());
    }
}

