/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job.service.impl;

import com.epam.ta.reportportal.dao.ActivityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.job.PageUtil;
import com.epam.ta.reportportal.job.service.LogCleanerService;
import com.epam.ta.reportportal.job.service.impl.AttachmentCleanerServiceImpl;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogCleanerServiceImpl
implements LogCleanerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogCleanerServiceImpl.class);
    private final Integer itemPageSize;
    private final LogRepository logRepository;
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final ActivityRepository activityRepository;
    private final AttachmentCleanerServiceImpl attachmentCleanerService;

    @Autowired
    public LogCleanerServiceImpl(@Value(value="${rp.environment.variable.clean.items.size}") Integer itemPageSize, LogRepository logRepository, LaunchRepository launchRepository, TestItemRepository testItemRepository, ActivityRepository activityRepository, AttachmentCleanerServiceImpl attachmentCleanerService) {
        this.itemPageSize = itemPageSize;
        this.logRepository = logRepository;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.activityRepository = activityRepository;
        this.attachmentCleanerService = attachmentCleanerService;
    }

    @Override
    @Transactional
    public void removeOutdatedLogs(Project project, Duration period, AtomicLong removedLogsCount) {
        LocalDateTime endDate = LocalDateTime.now(ZoneOffset.UTC).minus(period);
        AtomicLong logsCount = new AtomicLong(0L);
        AtomicLong attachmentsCount = new AtomicLong(0L);
        AtomicLong thumbnailsCount = new AtomicLong(0L);
        this.activityRepository.deleteModifiedLaterAgo(project.getId(), period);
        try (Stream launchIds = this.launchRepository.streamIdsByStartTimeBefore(project.getId(), endDate);){
            launchIds.forEach(id -> {
                PageUtil.iterateOverContent(this.itemPageSize, pageable -> this.testItemRepository.findTestItemIdsByLaunchId(id, pageable), ids -> {
                    this.attachmentCleanerService.removeOutdatedItemsAttachments((Collection<Long>)ids, endDate, attachmentsCount, thumbnailsCount);
                    long count = this.logRepository.deleteByPeriodAndTestItemIds(period, (Collection)ids);
                    removedLogsCount.addAndGet(count);
                    logsCount.addAndGet(count);
                });
                this.attachmentCleanerService.removeOutdatedLaunchesAttachments(Collections.singletonList(id), endDate, attachmentsCount, thumbnailsCount);
                long count = this.logRepository.deleteByPeriodAndLaunchIds(period, Collections.singletonList(id));
                removedLogsCount.addAndGet(count);
                logsCount.addAndGet(count);
            });
        }
        catch (Exception e) {
            LOGGER.error("Error during cleaning outdated logs", (Throwable)e);
        }
        if (logsCount.get() > 0L || attachmentsCount.get() > 0L || attachmentsCount.get() > 0L || thumbnailsCount.get() > 0L) {
            LOGGER.info("Removed {} logs for project {} with {} attachments and {} thumbnails", new Object[]{logsCount.get(), project.getId(), attachmentsCount.get(), thumbnailsCount.get()});
        }
    }
}

