/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.util.ReportingQueueService;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.item.ItemCreatedRS;
import com.epam.ta.reportportal.ws.rabbit.RequestType;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier(value="startTestItemHandlerAsync")
class StartTestItemHandlerAsyncImpl
implements StartTestItemHandler {
    @Autowired
    @Qualifier(value="rabbitTemplate")
    AmqpTemplate amqpTemplate;
    @Autowired
    private ReportingQueueService reportingQueueService;

    StartTestItemHandlerAsyncImpl() {
    }

    @Override
    public ItemCreatedRS startRootItem(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartTestItemRQ request) {
        request.setUuid(Optional.ofNullable(request.getUuid()).orElse(UUID.randomUUID().toString()));
        this.amqpTemplate.convertAndSend("reporting", this.reportingQueueService.getReportingQueueKey(request.getLaunchUuid()), (Object)request, message -> {
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("requestType", RequestType.START_TEST);
            headers.put("username", user.getUsername());
            headers.put("projectName", projectDetails.getProjectName());
            headers.put("parentItemId", "");
            return message;
        });
        ItemCreatedRS response = new ItemCreatedRS();
        response.setId(request.getUuid());
        return response;
    }

    @Override
    public ItemCreatedRS startChildItem(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartTestItemRQ request, String parentId) {
        request.setUuid(Optional.ofNullable(request.getUuid()).orElse(UUID.randomUUID().toString()));
        this.amqpTemplate.convertAndSend("reporting", this.reportingQueueService.getReportingQueueKey(request.getLaunchUuid()), (Object)request, message -> {
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("requestType", RequestType.START_TEST);
            headers.put("username", user.getUsername());
            headers.put("projectName", projectDetails.getProjectName());
            headers.put("parentItemId", parentId);
            return message;
        });
        ItemCreatedRS response = new ItemCreatedRS();
        response.setId(request.getUuid());
        return response;
    }
}

