/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.settings.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.pattern.CreatePatternTemplateHandler;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.DefectTypeCreatedEvent;
import com.epam.ta.reportportal.core.events.activity.PatternCreatedEvent;
import com.epam.ta.reportportal.core.project.settings.CreateProjectSettingsHandler;
import com.epam.ta.reportportal.dao.IssueGroupRepository;
import com.epam.ta.reportportal.dao.IssueTypeRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.pattern.PatternTemplate;
import com.epam.ta.reportportal.entity.pattern.PatternTemplateType;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectIssueType;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.IssueTypeBuilder;
import com.epam.ta.reportportal.ws.converter.converters.IssueTypeConverter;
import com.epam.ta.reportportal.ws.converter.converters.PatternTemplateConverter;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.project.config.CreateIssueSubTypeRQ;
import com.epam.ta.reportportal.ws.model.project.config.IssueSubTypeCreatedRS;
import com.epam.ta.reportportal.ws.model.project.config.pattern.CreatePatternTemplateRQ;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CreateProjectSettingsHandlerImpl
implements CreateProjectSettingsHandler {
    private static final Map<String, String> PREFIX = ImmutableMap.builder().put((Object)TestItemIssueGroup.AUTOMATION_BUG.getValue(), (Object)"ab_").put((Object)TestItemIssueGroup.PRODUCT_BUG.getValue(), (Object)"pb_").put((Object)TestItemIssueGroup.SYSTEM_ISSUE.getValue(), (Object)"si_").put((Object)TestItemIssueGroup.NO_DEFECT.getValue(), (Object)"nd_").put((Object)TestItemIssueGroup.TO_INVESTIGATE.getValue(), (Object)"ti_").build();
    private final ProjectRepository projectRepository;
    private final WidgetRepository widgetRepository;
    private final IssueGroupRepository issueGroupRepository;
    private final IssueTypeRepository issueTypeRepository;
    private final Map<PatternTemplateType, CreatePatternTemplateHandler> createPatternTemplateMapping;
    private final MessageBus messageBus;

    @Autowired
    public CreateProjectSettingsHandlerImpl(ProjectRepository projectRepository, WidgetRepository widgetRepository, IssueGroupRepository issueGroupRepository, IssueTypeRepository issueTypeRepository, @Qualifier(value="createPatternTemplateMapping") Map<PatternTemplateType, CreatePatternTemplateHandler> createPatternTemplateMapping, MessageBus messageBus) {
        this.projectRepository = projectRepository;
        this.widgetRepository = widgetRepository;
        this.issueGroupRepository = issueGroupRepository;
        this.issueTypeRepository = issueTypeRepository;
        this.createPatternTemplateMapping = createPatternTemplateMapping;
        this.messageBus = messageBus;
    }

    @Override
    public IssueSubTypeCreatedRS createProjectIssueSubType(String projectName, ReportPortalUser user, CreateIssueSubTypeRQ rq) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        BusinessRule.expect((Object)TestItemIssueGroup.NOT_ISSUE_FLAG.getValue().equalsIgnoreCase(rq.getTypeRef()), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Impossible to create sub-type for 'Not Issue' type."});
        TestItemIssueGroup expectedGroup = (TestItemIssueGroup)TestItemIssueGroup.fromValue((String)rq.getTypeRef()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{rq.getTypeRef()}));
        List existingSubTypes = project.getProjectIssueTypes().stream().filter(projectIssueType -> projectIssueType.getIssueType().getIssueGroup().getTestItemIssueGroup().equals((Object)expectedGroup)).collect(Collectors.toList());
        BusinessRule.expect((Object)(existingSubTypes.size() < 15 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Sub Issues count is bound of size limit"});
        String locator = PREFIX.get(expectedGroup.getValue()) + CreateProjectSettingsHandlerImpl.shortUUID();
        IssueType subType = new IssueTypeBuilder().addLocator(locator).addIssueGroup(this.issueGroupRepository.findByTestItemIssueGroup(expectedGroup)).addLongName(rq.getLongName()).addShortName(rq.getShortName()).addHexColor(rq.getColor()).get();
        ProjectIssueType projectIssueType2 = new ProjectIssueType();
        projectIssueType2.setIssueType(subType);
        projectIssueType2.setProject(project);
        project.getProjectIssueTypes().add(projectIssueType2);
        this.issueTypeRepository.save((Object)subType);
        this.projectRepository.save((Object)project);
        this.updateWidgets(project, subType);
        this.messageBus.publishActivity(new DefectTypeCreatedEvent(IssueTypeConverter.TO_ACTIVITY_RESOURCE.apply(subType), user.getUserId(), user.getUsername(), project.getId()));
        return new IssueSubTypeCreatedRS(subType.getId(), subType.getLocator());
    }

    private void updateWidgets(Project project, IssueType issueType) {
        String issueGroupContentField = "statistics$defects$" + issueType.getIssueGroup().getTestItemIssueGroup().getValue().toLowerCase() + "$";
        this.widgetRepository.findAllByProjectIdAndWidgetTypeInAndContentFieldContaining(project.getId(), Arrays.stream(WidgetType.values()).filter(WidgetType::isIssueTypeUpdateSupported).map(WidgetType::getType).collect(Collectors.toList()), issueGroupContentField).forEach(widget -> {
            widget.getContentFields().add(issueGroupContentField + issueType.getLocator());
            this.widgetRepository.save(widget);
        });
    }

    @Override
    public EntryCreatedRS createPatternTemplate(String projectName, CreatePatternTemplateRQ createPatternTemplateRQ, ReportPortalUser user) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        PatternTemplate patternTemplate = this.createPatternTemplateMapping.get(PatternTemplateType.fromString((String)createPatternTemplateRQ.getType()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unknown pattern template type - '{}'", (Object[])new Object[]{createPatternTemplateRQ.getType()}).get()}))).createPatternTemplate(project.getId(), createPatternTemplateRQ);
        this.messageBus.publishActivity(new PatternCreatedEvent(user.getUserId(), user.getUsername(), PatternTemplateConverter.TO_ACTIVITY_RESOURCE.apply(patternTemplate)));
        return new EntryCreatedRS(patternTemplate.getId());
    }

    private static String shortUUID() {
        long l = ByteBuffer.wrap(UUID.randomUUID().toString().getBytes(Charsets.UTF_8)).getLong();
        return Long.toString(l, 36);
    }
}

