/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.core.filter.predefined.PredefinedFilters;
import com.epam.ta.reportportal.core.widget.content.LoadContentStrategy;
import com.epam.ta.reportportal.core.widget.content.loader.util.FilterUtils;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.entity.widget.content.LatestLaunchContent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.jooq.enums.JTestItemTypeEnum;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class MostTimeConsumingContentLoader
implements LoadContentStrategy {
    public static final int MOST_TIME_CONSUMING_CASES_COUNT = 20;
    private final LaunchRepository launchRepository;
    private final WidgetContentRepository widgetContentRepository;

    @Autowired
    public MostTimeConsumingContentLoader(LaunchRepository launchRepository, WidgetContentRepository widgetContentRepository) {
        this.launchRepository = launchRepository;
        this.widgetContentRepository = widgetContentRepository;
    }

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMap, WidgetOptions widgetOptions, int limit) {
        Filter filter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMap.keySet());
        String launchName = WidgetOptionUtil.getValueByKey("launchNameFilter", widgetOptions);
        Launch latestLaunch = (Launch)this.launchRepository.findLatestByFilter(FilterUtils.buildLatestLaunchFilter(filter, launchName)).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{"No launch with name: " + launchName}));
        List content = this.widgetContentRepository.mostTimeConsumingTestCasesStatistics(filter = this.updateFilter(filter, latestLaunch.getId(), widgetOptions, contentFields), 20);
        return content.isEmpty() ? Collections.emptyMap() : ImmutableMap.builder().put((Object)"latestLaunch", (Object)new LatestLaunchContent(latestLaunch)).put((Object)"result", (Object)content).build();
    }

    private Filter updateFilter(Filter filter, Long launchId, WidgetOptions widgetOptions, List<String> contentFields) {
        filter = filter.withCondition((ConvertibleCondition)FilterCondition.builder().eq("launchId", String.valueOf(launchId)).build());
        filter = this.updateFilterWithStatuses(filter, contentFields);
        filter = this.updateFilterWithTestItemTypes(filter, Optional.ofNullable(widgetOptions.getOptions().get("includeMethods")).map(v -> BooleanUtils.toBoolean((String)String.valueOf(v))).orElse(false));
        return filter.withCondition((ConvertibleCondition)FilterCondition.builder().eq("hasChildren", Boolean.FALSE.toString()).build()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("hasStats", Boolean.TRUE.toString()).build());
    }

    private Filter updateFilterWithStatuses(Filter filter, List<String> contentFields) {
        if (CollectionUtils.isNotEmpty(contentFields)) {
            String statusCriteria = contentFields.stream().filter(StringUtils::isNotBlank).map(it -> it.split("\\$")).map(split -> split[((String[])split).length - 1].toUpperCase()).filter(cf -> StatusEnum.fromValue((String)cf).isPresent()).collect(Collectors.joining(", "));
            return filter.withCondition((ConvertibleCondition)FilterCondition.builder().withSearchCriteria("status").withCondition(Condition.IN).withValue(statusCriteria).build());
        }
        return filter;
    }

    private Filter updateFilterWithTestItemTypes(Filter filter, boolean includeMethodsFlag) {
        return includeMethodsFlag ? this.updateFilterWithStepAndBeforeAfterMethods(filter) : this.updateFilterWithStepTestItem(filter);
    }

    private Filter updateFilterWithStepTestItem(Filter filter) {
        return filter.withCondition((ConvertibleCondition)FilterCondition.builder().eq("type", JTestItemTypeEnum.STEP.getLiteral()).build());
    }

    private Filter updateFilterWithStepAndBeforeAfterMethods(Filter filter) {
        ArrayList itemTypes = Lists.newArrayList((Object[])new TestItemTypeEnum[]{TestItemTypeEnum.STEP});
        itemTypes.addAll(PredefinedFilters.HAS_METHOD_OR_CLASS);
        return filter.withCondition((ConvertibleCondition)FilterCondition.builder().withCondition(Condition.IN).withSearchCriteria("type").withValue(itemTypes.stream().map(Enum::name).collect(Collectors.joining(","))).build());
    }
}

