/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.ProjectFilter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.filter.GetUserFilterHandler;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.core.widget.GetWidgetHandler;
import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.core.widget.content.LoadContentStrategy;
import com.epam.ta.reportportal.core.widget.content.MaterializedLoadContentStrategy;
import com.epam.ta.reportportal.core.widget.content.MultilevelLoadContentStrategy;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.ShareableEntity;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import com.epam.ta.reportportal.ws.converter.converters.WidgetConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.WidgetPreviewRQ;
import com.epam.ta.reportportal.ws.model.widget.WidgetResource;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class GetWidgetHandlerImpl
implements GetWidgetHandler {
    private Map<WidgetType, BuildFilterStrategy> buildFilterStrategyMapping;
    private Map<WidgetType, LoadContentStrategy> loadContentStrategy;
    private Map<WidgetType, MultilevelLoadContentStrategy> multilevelLoadContentStrategy;
    private MaterializedLoadContentStrategy materializedLoadContentStrategy;
    private Set<WidgetType> unfilteredWidgetTypes;
    @Autowired
    private GetShareableEntityHandler<Widget> getShareableEntityHandler;
    @Autowired
    private WidgetRepository widgetRepository;
    @Autowired
    private GetUserFilterHandler getUserFilterHandler;

    @Autowired
    @Qualifier(value="buildFilterStrategy")
    public void setBuildFilterStrategy(Map<WidgetType, BuildFilterStrategy> buildFilterStrategyMapping) {
        this.buildFilterStrategyMapping = buildFilterStrategyMapping;
    }

    @Autowired
    @Qualifier(value="contentLoader")
    public void setLoadContentStrategy(Map<WidgetType, LoadContentStrategy> loadContentStrategy) {
        this.loadContentStrategy = loadContentStrategy;
    }

    @Autowired
    @Qualifier(value="multilevelContentLoader")
    public void setMultilevelLoadContentStrategy(Map<WidgetType, MultilevelLoadContentStrategy> multilevelLoadContentStrategy) {
        this.multilevelLoadContentStrategy = multilevelLoadContentStrategy;
    }

    @Autowired
    public void setMaterializedLoadContentStrategy(MaterializedLoadContentStrategy materializedLoadContentStrategy) {
        this.materializedLoadContentStrategy = materializedLoadContentStrategy;
    }

    @Autowired
    @Qualifier(value="unfilteredWidgetTypes")
    public void setUnfilteredWidgetTypes(Set<WidgetType> unfilteredWidgetTypes) {
        this.unfilteredWidgetTypes = unfilteredWidgetTypes;
    }

    @Override
    public WidgetResource getWidget(Long widgetId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Widget widget = this.getShareableEntityHandler.getPermitted(widgetId, projectDetails);
        WidgetType widgetType = (WidgetType)WidgetType.findByName((String)widget.getWidgetType()).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Unsupported widget type '{}'", (Object[])new Object[]{widget.getWidgetType()})}));
        BusinessRule.expect((Object)widgetType.isSupportMultilevelStructure(), Predicate.isEqual(false)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Unsupported widget type '{}'", (Object[])new Object[]{widgetType})});
        Map<Object, Object> content = this.unfilteredWidgetTypes.contains(widgetType) || this.isFilteredContentLoadAllowed(widget.getFilters(), projectDetails, user) != false ? this.loadContentStrategy.get(widgetType).loadContent(Lists.newArrayList((Iterable)widget.getContentFields()), this.buildFilterStrategyMapping.get(widgetType).buildFilter(widget), widget.getWidgetOptions(), widget.getItemsCount()) : Collections.emptyMap();
        WidgetResource resource = WidgetConverter.TO_WIDGET_RESOURCE.apply(widget);
        resource.setContent(content);
        return resource;
    }

    @Override
    public WidgetResource getWidget(Long widgetId, String[] attributes, MultiValueMap<String, String> params, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Map content;
        Widget widget = this.getShareableEntityHandler.getPermitted(widgetId, projectDetails);
        WidgetType widgetType = (WidgetType)WidgetType.findByName((String)widget.getWidgetType()).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Unsupported widget type '{}'", (Object[])new Object[]{widget.getWidgetType()})}));
        BusinessRule.expect((Object)widgetType.isSupportMultilevelStructure(), Predicate.isEqual(true)).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Widget type '{}' does not support multilevel structure.", (Object[])new Object[]{widgetType})});
        if (this.unfilteredWidgetTypes.contains(widgetType) || this.isFilteredContentLoadAllowed(widget.getFilters(), projectDetails, user).booleanValue()) {
            params.put((Object)"attributes", (Object)Lists.newArrayList((Object[])attributes));
            content = Optional.ofNullable(this.multilevelLoadContentStrategy.get(widgetType)).map(strategy -> strategy.loadContent(Lists.newArrayList((Iterable)widget.getContentFields()), this.buildFilterStrategyMapping.get(widgetType).buildFilter(widget), widget.getWidgetOptions(), attributes, params, widget.getItemsCount())).orElseGet(() -> this.materializedLoadContentStrategy.loadContent(widget, params));
        } else {
            content = Collections.emptyMap();
        }
        WidgetResource resource = WidgetConverter.TO_WIDGET_RESOURCE.apply(widget);
        resource.setContent(content);
        return resource;
    }

    private Boolean isFilteredContentLoadAllowed(Collection<UserFilter> userFilters, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        if (CollectionUtils.isEmpty(userFilters)) {
            return false;
        }
        Long[] ids = (Long[])userFilters.stream().map(ShareableEntity::getId).toArray(Long[]::new);
        List<UserFilter> permittedFilters = this.getPermittedFilters(ids, projectDetails, user);
        return userFilters.size() == permittedFilters.size();
    }

    @Override
    public Map<String, ?> getWidgetPreview(WidgetPreviewRQ previewRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        WidgetType widgetType = (WidgetType)WidgetType.findByName((String)previewRQ.getWidgetType()).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Unsupported widget type '{}'", (Object[])new Object[]{previewRQ.getWidgetType()})}));
        List<UserFilter> userFilter = null;
        if (CollectionUtils.isNotEmpty((Collection)previewRQ.getFilterIds())) {
            userFilter = this.getPermittedFilters((Long[])previewRQ.getFilterIds().toArray(Long[]::new), projectDetails, user);
        }
        if (!this.unfilteredWidgetTypes.contains(widgetType) && CollectionUtils.isEmpty(userFilter)) {
            return Collections.emptyMap();
        }
        Widget widget = new WidgetBuilder().addWidgetPreviewRq(previewRQ).addProject(projectDetails.getProjectId()).addFilters(userFilter).get();
        if (widgetType.isSupportMultilevelStructure()) {
            return this.multilevelLoadContentStrategy.get(widgetType).loadContent(Lists.newArrayList((Iterable)widget.getContentFields()), this.buildFilterStrategyMapping.get(widgetType).buildFilter(widget), widget.getWidgetOptions(), null, null, widget.getItemsCount());
        }
        return this.loadContentStrategy.get(widgetType).loadContent(Lists.newArrayList((Iterable)widget.getContentFields()), this.buildFilterStrategyMapping.get(widgetType).buildFilter(widget), widget.getWidgetOptions(), widget.getItemsCount());
    }

    List<UserFilter> getPermittedFilters(Long[] ids, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        return this.getUserFilterHandler.getFiltersById(ids, projectDetails, user);
    }

    @Override
    public Iterable<Object> getOwnNames(ReportPortalUser.ProjectDetails projectDetails, Pageable pageable, Filter filter, ReportPortalUser user) {
        Page own = this.widgetRepository.getOwn(ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable, user.getUsername());
        return (Iterable)PagedResourcesAssembler.pageConverter().apply(own.map(Widget::getName));
    }

    @Override
    public Iterable<WidgetResource> getShared(ReportPortalUser.ProjectDetails projectDetails, Pageable pageable, Filter filter, ReportPortalUser user) {
        Page shared = this.widgetRepository.getShared(ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable, user.getUsername());
        return (Iterable)PagedResourcesAssembler.pageConverter(WidgetConverter.TO_WIDGET_RESOURCE).apply((Page<Widget>)shared);
    }

    @Override
    public Iterable<WidgetResource> searchShared(ReportPortalUser.ProjectDetails projectDetails, Pageable pageable, Filter filter, ReportPortalUser user, String term) {
        Filter termFilter = Filter.builder().withTarget(Widget.class).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, term, "name")).withCondition((ConvertibleCondition)new FilterCondition(Operator.OR, Condition.CONTAINS, false, term, "owner")).build();
        Page shared = this.widgetRepository.getShared(ProjectFilter.of((Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, termFilter}), (Long)projectDetails.getProjectId()), pageable, user.getUsername());
        return (Iterable)PagedResourcesAssembler.pageConverter(WidgetConverter.TO_WIDGET_RESOURCE).apply((Page<Widget>)shared);
    }
}

