/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.job.PageUtil;
import com.epam.ta.reportportal.job.service.LogCleanerService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.math.NumberUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!unittest"})
public class CleanLogsJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanLogsJob.class);
    public static final int DEFAULT_THREAD_COUNT = 5;
    @Value(value="5")
    private Integer threadsCount;
    private final ProjectRepository projectRepository;
    private final LogCleanerService logCleaner;

    @Autowired
    public CleanLogsJob(ProjectRepository projectRepository, LogCleanerService logCleaner) {
        this.projectRepository = projectRepository;
        this.logCleaner = logCleaner;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOGGER.info("Cleaning outdated logs has been started");
        ExecutorService executor = Executors.newFixedThreadPool(Optional.ofNullable(this.threadsCount).orElse(5), new ThreadFactoryBuilder().setNameFormat("clean-logs-job-thread-%d").build());
        PageUtil.iterateOverPages(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"id")}), arg_0 -> ((ProjectRepository)this.projectRepository).findAllIdsAndProjectAttributes(arg_0), projects -> CompletableFuture.allOf((CompletableFuture[])projects.stream().map(project -> {
            AtomicLong removedLogsCount = new AtomicLong(0L);
            return CompletableFuture.runAsync(() -> {
                try {
                    LOGGER.debug("Cleaning outdated logs for project {} has been started", (Object)project.getId());
                    this.proceedLogsRemoving((Project)project, removedLogsCount);
                }
                catch (Exception e) {
                    LOGGER.debug("Cleaning outdated logs for project {} has been failed", (Object)project.getId(), (Object)e);
                }
                LOGGER.info("Cleaning outdated logs for project {} has been finished. Total logs removed: {}", (Object)project.getId(), (Object)removedLogsCount.get());
            }, executor);
        }).toArray(CompletableFuture[]::new)).join());
        executor.shutdown();
    }

    private void proceedLogsRemoving(Project project, AtomicLong removedLogsCount) {
        ProjectUtils.extractAttributeValue((Project)project, (ProjectAttributeEnum)ProjectAttributeEnum.KEEP_LOGS).map(it -> Duration.ofSeconds(NumberUtils.toLong((String)it, (long)0L))).filter(it -> !it.isZero()).ifPresent(it -> this.logCleaner.removeOutdatedLogs(project, (Duration)it, removedLogsCount));
    }
}

